/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.diagnosis.instance;

import io.vertx.core.json.Json;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.diagnosis.Status;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheResult;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCacheChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceCacheChecker.class);
    private AppManager appManager;
    private Set<Status> statuses = new HashSet<Status>();
    private InstanceCacheSummary instanceCacheSummary = new InstanceCacheSummary();

    public InstanceCacheChecker(AppManager appManager) {
        this.appManager = appManager;
    }

    public InstanceCacheSummary check() {
        this.instanceCacheSummary.setAppId(RegistryUtils.getMicroservice().getAppId());
        this.instanceCacheSummary.setMicroserviceName(RegistryUtils.getMicroservice().getServiceName());
        this.instanceCacheSummary.setTimestamp(System.currentTimeMillis());
        for (MicroserviceManager microserviceManager : this.appManager.getApps().values()) {
            for (MicroserviceVersions microserviceVersions : microserviceManager.getVersionsByName().values()) {
                InstanceCacheResult instanceCacheResult = this.check(microserviceVersions);
                this.addInstanceCacheResult(instanceCacheResult);
            }
        }
        this.generateStatus();
        return this.instanceCacheSummary;
    }

    private void addInstanceCacheResult(InstanceCacheResult instanceCacheResult) {
        this.statuses.add(instanceCacheResult.getStatus());
        this.instanceCacheSummary.getProducers().add(instanceCacheResult);
    }

    protected InstanceCacheResult check(MicroserviceVersions microserviceVersions) {
        InstanceCacheResult instanceCacheResult = new InstanceCacheResult();
        instanceCacheResult.setAppId(microserviceVersions.getAppId());
        instanceCacheResult.setMicroserviceName(microserviceVersions.getMicroserviceName());
        MicroserviceInstances microserviceInstances = RegistryUtils.findServiceInstances(microserviceVersions.getAppId(), microserviceVersions.getMicroserviceName(), "0.0.0+", null);
        if (microserviceInstances == null) {
            instanceCacheResult.setStatus(Status.UNKNOWN);
            instanceCacheResult.setDetail("failed to find instances from service center");
            return instanceCacheResult;
        }
        if (microserviceInstances.isMicroserviceNotExist()) {
            instanceCacheResult.setStatus(Status.UNKNOWN);
            instanceCacheResult.setDetail("microservice is not exist anymore, will be deleted from memory in next pull");
            return instanceCacheResult;
        }
        if (!Objects.equals(microserviceInstances.getRevision(), microserviceVersions.getRevision())) {
            instanceCacheResult.setStatus(Status.UNKNOWN);
            instanceCacheResult.setDetail(String.format("revision is different, will be synchronized in next pull. local revision=%s, remote revision=%s", microserviceVersions.getRevision(), microserviceInstances.getRevision()));
            return instanceCacheResult;
        }
        List<MicroserviceInstance> remoteInstances = microserviceInstances.getInstancesResponse().getInstances();
        remoteInstances.sort(Comparator.comparing(MicroserviceInstance::getInstanceId));
        String local = Json.encode(microserviceVersions.getPulledInstances());
        String remote = Json.encode(remoteInstances);
        if (local.equals(remote)) {
            instanceCacheResult.setStatus(Status.NORMAL);
            return instanceCacheResult;
        }
        LOGGER.error("instance cache not match. appId={}, microservice={}.\nlocal cache: {}\nremote cache: {}", new Object[]{microserviceVersions.getAppId(), microserviceVersions.getMicroserviceName(), local, remote});
        instanceCacheResult.setStatus(Status.ABNORMAL);
        instanceCacheResult.setDetail("instance cache not match");
        microserviceVersions.setRevision(null);
        return instanceCacheResult;
    }

    protected void generateStatus() {
        if (this.statuses.contains((Object)Status.ABNORMAL)) {
            this.instanceCacheSummary.setStatus(Status.ABNORMAL);
        } else if (this.statuses.contains((Object)Status.UNKNOWN)) {
            this.instanceCacheSummary.setStatus(Status.UNKNOWN);
        } else {
            this.instanceCacheSummary.setStatus(Status.NORMAL);
        }
    }
}

