/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.version;

import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;

public class Version
implements Comparable<Version> {
    private static final String[] ZERO = new String[]{"0", "0", "0"};
    private final short major;
    private final short minor;
    private final short patch;
    private final String version;
    private final long numberVersion;

    public Version(String version) {
        Objects.requireNonNull(version);
        Object[] versions = version.split("\\.", -1);
        if (versions.length > 3) {
            throw new IllegalStateException(String.format("Invalid version \"%s\".", version));
        }
        if (versions.length < 3) {
            versions = (String[])ArrayUtils.addAll((Object[])versions, (Object[])ZERO);
        }
        this.major = this.parseNumber("major", version, (String)versions[0]);
        this.minor = this.parseNumber("minor", version, (String)versions[1]);
        this.patch = this.parseNumber("patch", version, (String)versions[2]);
        this.version = this.combineStringVersion();
        this.numberVersion = this.combineVersion();
    }

    private short parseNumber(String name, String allVersion, String version) {
        short value = 0;
        try {
            value = Short.parseShort(version);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Invalid %s \"%s\", version \"%s\".", name, version, allVersion), e);
        }
        if (value < 0) {
            throw new IllegalStateException(String.format("%s \"%s\" can not be negative, version \"%s\".", name, version, allVersion));
        }
        return value;
    }

    public Version(short major, short minor, short patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.version = this.combineStringVersion();
        this.numberVersion = this.combineVersion();
    }

    private String combineStringVersion() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    private long combineVersion() {
        return (long)this.major << 32 | (long)this.minor << 16 | (long)this.patch;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getPatch() {
        return this.patch;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.version;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.numberVersion == ((Version)other).numberVersion;
    }

    @Override
    public int compareTo(Version other) {
        return Long.compare(this.numberVersion, other.numberVersion);
    }
}

