/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.EventBus;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.task.event.SafeModeChangeEvent;

public class AppManager {
    private Map<String, MicroserviceManager> apps = new ConcurrentHashMapEx();

    public AppManager() {
        this.getEventBus().register((Object)this);
    }

    public EventBus getEventBus() {
        return EventManager.getEventBus();
    }

    public Map<String, MicroserviceManager> getApps() {
        return this.apps;
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String appId, String microserviceName, String versionRule) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersionRule(microserviceName, versionRule);
    }

    public MicroserviceManager getOrCreateMicroserviceManager(String appId) {
        return this.apps.computeIfAbsent(appId, id -> new MicroserviceManager(this, appId));
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String appId, String microserviceName) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersions(microserviceName);
    }

    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        MicroserviceManager microserviceManager = this.apps.get(changedEvent.getKey().getAppId());
        if (microserviceManager == null) {
            return;
        }
        microserviceManager.onMicroserviceInstanceChanged(changedEvent);
    }

    public void onSafeModeChanged(SafeModeChangeEvent modeChangeEvent) {
        this.apps.values().forEach(microserviceManager -> microserviceManager.onSafeModeChanged(modeChangeEvent));
    }

    public void pullInstances() {
        for (MicroserviceManager microserviceManager : this.apps.values()) {
            microserviceManager.pullInstances();
        }
    }
}

