/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.api.response.MicroserviceInstanceChangedEvent;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.task.event.SafeModeChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceManager.class);
    private AppManager appManager;
    private String appId;
    private Map<String, MicroserviceVersions> versionsByName = new ConcurrentHashMapEx();

    public MicroserviceManager(AppManager appManager, String appId) {
        this.appManager = appManager;
        this.appId = appId;
    }

    public Map<String, MicroserviceVersions> getVersionsByName() {
        return this.versionsByName;
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String microserviceName) {
        MicroserviceVersions microserviceVersions = this.versionsByName.computeIfAbsent(microserviceName, name -> {
            MicroserviceVersions instance = new MicroserviceVersions(this.appManager, this.appId, microserviceName);
            instance.pullInstances();
            return instance;
        });
        this.tryRemoveInvalidMicroservice(microserviceVersions);
        return microserviceVersions;
    }

    private void tryRemoveInvalidMicroservice(MicroserviceVersions microserviceVersions) {
        if (!microserviceVersions.isWaitingDelete()) {
            return;
        }
        String microserviceName = microserviceVersions.getMicroserviceName();
        if (this.versionsByName.remove(microserviceName) != null) {
            microserviceVersions.destroy();
            LOGGER.info("remove microservice, appId={}, microserviceName={}.", (Object)this.appId, (Object)microserviceName);
        }
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String microserviceName, String versionRule) {
        MicroserviceVersions microserviceVersions = this.getOrCreateMicroserviceVersions(microserviceName);
        return microserviceVersions.getOrCreateMicroserviceVersionRule(versionRule);
    }

    public void pullInstances() {
        for (MicroserviceVersions microserviceVersions : this.versionsByName.values()) {
            microserviceVersions.pullInstances();
            this.tryRemoveInvalidMicroservice(microserviceVersions);
        }
    }

    public void onMicroserviceInstanceChanged(MicroserviceInstanceChangedEvent changedEvent) {
        for (MicroserviceVersions microserviceVersions : this.versionsByName.values()) {
            microserviceVersions.onMicroserviceInstanceChanged(changedEvent);
            this.tryRemoveInvalidMicroservice(microserviceVersions);
        }
    }

    public void onSafeModeChanged(SafeModeChangeEvent modeChangeEvent) {
        this.versionsByName.values().forEach(microserviceVersions -> microserviceVersions.onSafeModeChanged(modeChangeEvent));
    }
}

