/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.consumer;

import io.swagger.models.Swagger;
import java.util.List;
import java.util.UUID;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.api.response.FindInstancesResponse;
import org.apache.servicecomb.serviceregistry.client.http.MicroserviceInstances;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.version.Version;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMicroserviceVersions
extends MicroserviceVersions {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticMicroserviceVersions.class);
    private Class<?> schemaIntfCls;
    private Microservice microservice = new Microservice();
    private MicroserviceInstances microserviceInstances = new MicroserviceInstances();

    public StaticMicroserviceVersions(AppManager appManager, String appId, String microserviceName) {
        super(appManager, appId, microserviceName);
    }

    public StaticMicroserviceVersions init(Class<?> schemaIntfCls, String version, List<MicroserviceInstance> addedInstances) {
        this.schemaIntfCls = schemaIntfCls;
        Swagger swagger = RegistryUtils.getSwaggerLoader().registerSwagger(this.appId, this.shortName, this.shortName, schemaIntfCls);
        String swaggerContent = SwaggerUtils.swaggerToString((Swagger)swagger);
        LOGGER.info("generate swagger for 3rd party service [{}]/[{}], swagger: {}", new Object[]{this.getMicroserviceName(), version, swaggerContent});
        this.microservice.addSchema(this.shortName, swaggerContent);
        this.createMicroservice(version);
        for (MicroserviceInstance instance : addedInstances) {
            instance.setServiceId(this.microservice.getServiceId());
            instance.setInstanceId(this.microservice.getServiceId() + "-" + UUID.randomUUID());
        }
        this.microserviceInstances.setMicroserviceNotExist(false);
        this.microserviceInstances.setInstancesResponse(new FindInstancesResponse());
        this.microserviceInstances.getInstancesResponse().setInstances(addedInstances);
        this.pullInstances();
        return this;
    }

    public Class<?> getSchemaIntfCls() {
        return this.schemaIntfCls;
    }

    @Override
    protected MicroserviceInstances findServiceInstances() {
        this.microserviceInstances.setNeedRefresh(this.revision == null);
        this.microserviceInstances.setRevision("1");
        return this.microserviceInstances;
    }

    @Override
    protected MicroserviceVersion createMicroserviceVersion(String microserviceId, List<MicroserviceInstance> instances) {
        return new MicroserviceVersion((MicroserviceVersions)this, this.microservice, this.microserviceName, instances);
    }

    private void createMicroservice(String version) {
        String environment = RegistryUtils.getMicroservice().getEnvironment();
        this.microservice.setAppId(this.getAppId());
        this.microservice.setServiceName(this.getShortName());
        this.microservice.setVersion(new Version(version).getVersion());
        this.microservice.setServiceId(this.getAppId() + "-" + environment + "-" + this.getMicroserviceName() + "-" + this.microservice.getVersion());
        this.microservice.setEnvironment(environment);
    }
}

