/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.foundation.common.concurrency.SuppressedRunnableWrapper;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.apache.servicecomb.serviceregistry.registry.AbstractServiceRegistry;
import org.apache.servicecomb.serviceregistry.registry.ServiceRegistryTaskInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceRegistry
extends AbstractServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteServiceRegistry.class);
    private ScheduledThreadPoolExecutor taskPool;
    private List<ServiceRegistryTaskInitializer> taskInitializers = SPIServiceUtils.getOrLoadSortedService(ServiceRegistryTaskInitializer.class);

    public RemoteServiceRegistry(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        super(eventBus, serviceRegistryConfig, microserviceDefinition);
    }

    @Override
    public void init() {
        super.init();
        this.taskPool = new ScheduledThreadPoolExecutor(3, new ThreadFactory(){
            private int taskId = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, RemoteServiceRegistry.super.getName() + " Service Center Task [" + this.taskId++ + "]");
                thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Service Center Task Thread is terminated! thread: [{}]", (Object)t, (Object)e));
                return thread;
            }
        }, (task, executor) -> LOGGER.warn("Too many pending tasks, reject " + task.toString()));
        this.executorService = this.taskPool;
    }

    @Override
    protected ServiceRegistryClient createServiceRegistryClient() {
        return this.serviceRegistryConfig.createServiceRegistryClient(this);
    }

    @Override
    public void run() {
        super.run();
        this.taskPool.scheduleAtFixedRate(this.serviceCenterTask, this.serviceRegistryConfig.getHeartbeatInterval(), this.serviceRegistryConfig.getHeartbeatInterval(), TimeUnit.SECONDS);
        this.taskPool.scheduleAtFixedRate((Runnable)new SuppressedRunnableWrapper(() -> this.serviceRegistryCache.refreshCache()), this.serviceRegistryConfig.getInstancePullInterval(), this.serviceRegistryConfig.getInstancePullInterval(), TimeUnit.SECONDS);
        for (ServiceRegistryTaskInitializer initializer : this.taskInitializers) {
            initializer.init(this);
        }
    }

    public ScheduledThreadPoolExecutor getTaskPool() {
        return this.taskPool;
    }
}

