/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.springboot.starter.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTree;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class CseDiscoveryClient
implements DiscoveryClient {
    private Map<String, DiscoveryTree> discoveryTrees = new ConcurrentHashMapEx();

    public String description() {
        return "Spring Cloud CSE Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        DiscoveryContext context = new DiscoveryContext();
        context.setInputParameters((Object)serviceId);
        DiscoveryTree discoveryTree = this.discoveryTrees.computeIfAbsent(serviceId, key -> new DiscoveryTree());
        DiscoveryTreeNode serversVersionedCache = discoveryTree.discovery(context, RegistryUtils.getAppId(), serviceId, "0.0.0+");
        Map servers = (Map)serversVersionedCache.data();
        ArrayList<ServiceInstance> instances = new ArrayList<ServiceInstance>(servers.size());
        for (MicroserviceInstance s : servers.values()) {
            for (String endpoint : s.getEndpoints()) {
                URIEndpointObject uri = new URIEndpointObject(endpoint);
                instances.add((ServiceInstance)new DefaultServiceInstance(serviceId, uri.getHostOrIp(), uri.getPort(), uri.isSslEnabled()));
            }
        }
        return instances;
    }

    @Deprecated
    public ServiceInstance getLocalServiceInstance() {
        return null;
    }

    public List<String> getServices() {
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        List services = client.getAllMicroservices();
        ArrayList<String> serviceIDList = new ArrayList<String>();
        if (null != services && !services.isEmpty()) {
            for (Microservice service : services) {
                serviceIDList.add(service.getServiceName());
            }
        }
        return serviceIDList;
    }
}

