/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.springmvc.processor.annotation;

import io.swagger.models.Operation;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.springmvc.processor.annotation.AbstractHttpMethodMappingAnnotationProcessor;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingMethodAnnotationProcessor
extends AbstractHttpMethodMappingAnnotationProcessor {
    public void process(Object annotation, OperationGenerator operationGenerator) {
        RequestMapping requestMapping = (RequestMapping)annotation;
        Operation operation = operationGenerator.getOperation();
        this.processPath(requestMapping.path(), operationGenerator);
        this.processPath(requestMapping.value(), operationGenerator);
        this.processMethod(requestMapping.method(), operationGenerator);
        this.processConsumes(requestMapping.consumes(), operation);
        this.processProduces(requestMapping.produces(), operation);
        if (StringUtils.isEmpty((CharSequence)operationGenerator.getHttpMethod()) && StringUtils.isEmpty((CharSequence)operationGenerator.getSwaggerGenerator().getHttpMethod())) {
            throw new Error("HttpMethod must not both be empty in class and method");
        }
    }

    private void processMethod(RequestMethod[] requestMethods, OperationGenerator operationGenerator) {
        if (null == requestMethods || requestMethods.length == 0) {
            return;
        }
        if (requestMethods.length > 1) {
            throw new Error(String.format("not allowed multi http method for %s:%s", operationGenerator.getProviderMethod().getDeclaringClass().getName(), operationGenerator.getProviderMethod().getName()));
        }
        super.processMethod(requestMethods[0], operationGenerator);
    }
}

