/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUnit {
    protected ServiceMixComponent component;
    protected String name;
    protected String rootPath;
    protected String status = "Shutdown";
    protected Map<String, Endpoint> endpoints = new LinkedHashMap<String, Endpoint>();

    public ServiceUnit() {
    }

    public ServiceUnit(ServiceMixComponent component) {
        this.component = component;
    }

    public void start() throws Exception {
        ArrayList<Endpoint> activated = new ArrayList<Endpoint>();
        try {
            for (Endpoint endpoint : this.getEndpoints()) {
                endpoint.activate();
                activated.add(endpoint);
            }
            this.status = "Started";
        }
        catch (Exception e) {
            for (Endpoint endpoint : activated) {
                try {
                    endpoint.deactivate();
                }
                catch (Exception e2) {}
            }
            throw e;
        }
    }

    public void stop() throws Exception {
        this.status = "Stopped";
        Exception exception = null;
        for (Endpoint endpoint : this.getEndpoints()) {
            try {
                endpoint.deactivate();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void shutDown() throws JBIException {
        this.status = "Shutdown";
    }

    public String getCurrentState() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public ServiceMixComponent getComponent() {
        return this.component;
    }

    public void setComponent(ServiceMixComponent component) {
        this.component = component;
    }

    public Collection<Endpoint> getEndpoints() {
        return this.endpoints.values();
    }

    public void addEndpoint(Endpoint endpoint) throws DeploymentException {
        String key = EndpointSupport.getKey(endpoint);
        if (this.endpoints.put(key, endpoint) != null) {
            throw new DeploymentException("More than one endpoint found in the SU for key: " + key);
        }
        if (this.status == "Started") {
            try {
                endpoint.activate();
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public void removeEndpoint(Endpoint endpoint) throws DeploymentException {
        if (this.endpoints.remove(endpoint) != null) {
            throw new DeploymentException("Endpoint not found in the SU for key: " + EndpointSupport.getKey(endpoint));
        }
        if (this.status == "Started") {
            try {
                endpoint.deactivate();
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public Endpoint getEndpoint(String key) {
        return this.endpoints.get(key);
    }

    public ClassLoader getConfigurationClassLoader() {
        return this.component.getClass().getClassLoader();
    }
}

