/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.eip;

import java.net.URL;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.eip.support.ExchangeTarget;
import org.apache.servicemix.locks.LockManager;
import org.apache.servicemix.locks.impl.SimpleLockManager;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;
import org.apache.servicemix.timers.TimerManager;
import org.apache.servicemix.timers.impl.TimerManagerImpl;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;

public abstract class EIPEndpoint
extends ProviderEndpoint {
    protected Resource wsdlResource;
    protected Store store;
    protected StoreFactory storeFactory;
    protected LockManager lockManager;
    protected TimerManager timerManager;
    protected ExchangeTarget wsdlExchangeTarget;

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public void setTimerManager(TimerManager timerManager) {
        this.timerManager = timerManager;
    }

    public void start() throws Exception {
        super.start();
        if (this.store == null) {
            if (this.storeFactory == null) {
                this.storeFactory = new MemoryStoreFactory();
            }
            this.store = this.storeFactory.open(this.getService().toString() + this.getEndpoint());
        }
        if (this.lockManager == null) {
            this.lockManager = new SimpleLockManager();
        }
        if (this.timerManager == null) {
            this.timerManager = new TimerManagerImpl();
        }
        this.timerManager.start();
    }

    public void stop() throws Exception {
        if (this.timerManager != null) {
            this.timerManager.stop();
        }
        super.stop();
    }

    public void process(MessageExchange exchange) throws Exception {
        boolean txSync;
        boolean bl = txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
        if (txSync && exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.processSync(exchange);
        } else {
            this.processAsync(exchange);
        }
    }

    public Document getDescription() {
        if (this.description == null) {
            this.definition = this.getDefinition();
            if (this.definition != null) {
                try {
                    this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
                }
                catch (WSDLException wSDLException) {
                    // empty catch block
                }
            }
        }
        return this.description;
    }

    public Definition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinitionFromDescription();
            if (this.definition == null) {
                this.definition = this.getDefinitionFromWsdlResource();
                if (this.definition == null) {
                    this.definition = this.getDefinitionFromWsdlExchangeTarget();
                }
            }
        }
        return this.definition;
    }

    protected Definition getDefinitionFromDescription() {
        if (this.description != null) {
            try {
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                return reader.readWSDL(null, this.description);
            }
            catch (WSDLException wSDLException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Definition getDefinitionFromWsdlResource() {
        if (this.wsdlResource != null) {
            try {
                URL resource = this.wsdlResource.getURL();
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                return reader.readWSDL(null, resource.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Definition getDefinitionFromWsdlExchangeTarget() {
        if (this.wsdlExchangeTarget != null) {
            try {
                Document description = this.getDescriptionForExchangeTarget(this.wsdlExchangeTarget);
                WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
                reader.setFeature("javax.wsdl.verbose", false);
                return reader.readWSDL(null, description);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public Resource getWsdlResource() {
        return this.wsdlResource;
    }

    public void setWsdlResource(Resource wsdlResource) {
        this.wsdlResource = wsdlResource;
    }

    protected Document getDescriptionForExchangeTarget(ExchangeTarget match) throws JBIException {
        ServiceEndpoint[] endpoints = this.getEndpointsForExchangeTarget(match);
        if (endpoints == null || endpoints.length == 0) {
            return null;
        }
        ServiceEndpoint endpoint = this.chooseFirstEndpointWithDescriptor(endpoints);
        if (endpoint == null) {
            return null;
        }
        return this.getContext().getEndpointDescriptor(endpoint);
    }

    protected ServiceEndpoint[] getEndpointsForExchangeTarget(ExchangeTarget match) throws JBIException {
        ServiceEndpoint[] endpoints;
        if (match.getEndpoint() != null && match.getService() != null) {
            ServiceEndpoint endpoint = this.getContext().getEndpoint(match.getService(), match.getEndpoint());
            endpoints = endpoint == null ? new ServiceEndpoint[]{} : new ServiceEndpoint[]{endpoint};
        } else if (match.getService() != null) {
            endpoints = this.getContext().getEndpointsForService(match.getService());
        } else if (this.interfaceName != null) {
            endpoints = this.getContext().getEndpoints(this.interfaceName);
        } else {
            throw new IllegalStateException("One of interfaceName or serviceName should be provided");
        }
        return endpoints;
    }

    protected ServiceEndpoint chooseFirstEndpointWithDescriptor(ServiceEndpoint[] endpoints) throws JBIException {
        for (int i = 0; i < endpoints.length; ++i) {
            if (this.getContext().getEndpointDescriptor(endpoints[i]) == null) continue;
            return endpoints[i];
        }
        return null;
    }

    protected abstract void processAsync(MessageExchange var1) throws Exception;

    protected abstract void processSync(MessageExchange var1) throws Exception;

    public ExchangeTarget getWsdlExchangeTarget() {
        return this.wsdlExchangeTarget;
    }

    public void setWsdlExchangeTarget(ExchangeTarget wsdlExchangeTarget) {
        this.wsdlExchangeTarget = wsdlExchangeTarget;
    }
}

