/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.jbi.container.JBIContainer;
import org.apache.servicemix.jbi.framework.ComponentMBeanImpl;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HttpManagedServlet
extends HttpServlet {
    public static final String CONTAINER_PROPERTY = "container";
    public static final String CONTAINER_DEFAULT = "jbi";
    public static final String COMPONENT_PROPERTY = "component";
    public static final String COMPONENT_DEFAULT = "servicemix-http";
    public static final String MAPPING_PROPERTY = "mapping";
    private HttpProcessor processor;

    public void init(ServletConfig config) throws ServletException {
        ComponentMBeanImpl componentMBean;
        JBIContainer container;
        super.init(config);
        WebApplicationContext applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        String containerName = config.getInitParameter(CONTAINER_PROPERTY);
        if (containerName == null) {
            containerName = CONTAINER_DEFAULT;
        }
        if ((container = (JBIContainer)applicationContext.getBean(containerName)) == null) {
            throw new IllegalStateException("Unable to find jbi container " + containerName);
        }
        String componentName = config.getInitParameter(COMPONENT_PROPERTY);
        if (componentName == null) {
            componentName = COMPONENT_DEFAULT;
        }
        if ((componentMBean = container.getComponent(componentName)) == null) {
            throw new IllegalStateException("Unable to find component " + componentName);
        }
        HttpComponent component = (HttpComponent)componentMBean.getComponent();
        String mapping = config.getInitParameter(MAPPING_PROPERTY);
        if (mapping != null) {
            component.getConfiguration().setMapping(mapping);
        }
        this.processor = component.getMainProcessor();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processor.process(request, response);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException("Failed to process request: " + e, (Throwable)e);
        }
    }
}

