/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.wsdl1.AbstractWsdl1Deployer;
import org.apache.servicemix.common.wsdl1.JbiEndpoint;
import org.apache.servicemix.http.HttpEndpoint;

public class HttpWsdl1Deployer
extends AbstractWsdl1Deployer {
    public HttpWsdl1Deployer(ServiceMixComponent component) {
        super(component);
    }

    protected Endpoint createEndpoint(ExtensibilityElement portElement, ExtensibilityElement bindingElement, JbiEndpoint jbiEndpoint) {
        if (jbiEndpoint == null) {
            return null;
        }
        if (portElement instanceof HTTPAddress && bindingElement instanceof HTTPBinding) {
            if (!"POST".equals(((HTTPBinding)bindingElement).getVerb())) {
                throw new UnsupportedOperationException(((HTTPBinding)bindingElement).getVerb() + " not supported");
            }
            HttpEndpoint endpoint = new HttpEndpoint();
            endpoint.setSoap(false);
            endpoint.setRole(jbiEndpoint.getRole());
            endpoint.setDefaultMep(jbiEndpoint.getDefaultMep());
            endpoint.setDefaultOperation(jbiEndpoint.getDefaultOperation());
            endpoint.setLocationURI(((HTTPAddress)portElement).getLocationURI());
            return endpoint;
        }
        if (portElement instanceof SOAPAddress && bindingElement instanceof SOAPBinding) {
            HttpEndpoint endpoint = new HttpEndpoint();
            endpoint.setSoap(true);
            endpoint.setRole(jbiEndpoint.getRole());
            endpoint.setDefaultMep(jbiEndpoint.getDefaultMep());
            endpoint.setDefaultOperation(jbiEndpoint.getDefaultOperation());
            endpoint.setLocationURI(((SOAPAddress)portElement).getLocationURI());
            return endpoint;
        }
        return null;
    }

    protected boolean filterPortElement(ExtensibilityElement element) {
        String uri;
        if (element instanceof HTTPAddress) {
            return true;
        }
        return element instanceof SOAPAddress && ((uri = ((SOAPAddress)element).getLocationURI()).startsWith("http://") || uri.startsWith("https://"));
    }

    protected boolean filterBindingElement(ExtensibilityElement element) {
        return element instanceof HTTPBinding || element instanceof SOAPBinding;
    }
}

