/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.endpoints.DefaultHttpProviderMarshaler;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;

public class HttpProviderEndpoint
extends ProviderEndpoint
implements HttpEndpointType {
    private HttpProviderMarshaler marshaler;
    private String locationURI;

    public HttpProviderEndpoint() {
    }

    public HttpProviderEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public void start() throws Exception {
        if (this.marshaler == null) {
            DefaultHttpProviderMarshaler m = new DefaultHttpProviderMarshaler();
            m.setLocationURI(this.locationURI);
            this.marshaler = m;
        }
        super.start();
    }

    public HttpProviderMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpProviderMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            NormalizedMessage nm = exchange.getMessage("in");
            if (nm == null) {
                throw new IllegalStateException("Exchange has no input message");
            }
            Exchange httpEx = new Exchange(exchange);
            this.marshaler.createRequest(exchange, nm, httpEx);
            this.getConnectionPool().send((HttpExchange)httpEx);
        }
    }

    protected void handle(SmxHttpExchange httpExchange, MessageExchange exchange) throws IOException {
        try {
            boolean txSync;
            this.marshaler.handleResponse(exchange, httpExchange);
            boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    protected HttpClient getConnectionPool() {
        HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
        return comp.getConnectionPool();
    }

    protected class Exchange
    extends SmxHttpExchange {
        MessageExchange jbiExchange;

        public Exchange(MessageExchange jbiExchange) {
            this.jbiExchange = jbiExchange;
        }

        protected void onResponseComplete() throws IOException {
            HttpProviderEndpoint.this.handle(this, this.jbiExchange);
        }
    }
}

