/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.processors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpoint;
import org.apache.servicemix.http.processors.AbstractProcessor;
import org.apache.servicemix.http.processors.CommonsHttpSSLSocketFactory;
import org.apache.servicemix.soap.Context;
import org.apache.servicemix.soap.SoapEndpoint;
import org.apache.servicemix.soap.SoapHelper;
import org.apache.servicemix.soap.marshalers.SoapMessage;
import org.apache.servicemix.soap.marshalers.SoapReader;
import org.apache.servicemix.soap.marshalers.SoapWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderProcessor
extends AbstractProcessor
implements ExchangeProcessor {
    private static Log log = LogFactory.getLog(ProviderProcessor.class);
    protected SoapHelper soapHelper;
    protected DeliveryChannel channel;
    private Map<String, PostMethod> methods;
    private Protocol protocol;

    public ProviderProcessor(HttpEndpoint endpoint) {
        super(endpoint);
        this.soapHelper = new SoapHelper((SoapEndpoint)endpoint);
        this.methods = new ConcurrentHashMap<String, PostMethod>();
    }

    private String getRelUri(String locationUri) {
        java.net.URI uri = java.net.URI.create(locationUri);
        String relUri = uri.getPath();
        if (!relUri.startsWith("/")) {
            relUri = "/" + relUri;
        }
        if (uri.getQuery() != null) {
            relUri = relUri + "?" + uri.getQuery();
        }
        if (uri.getFragment() != null) {
            relUri = relUri + "#" + uri.getFragment();
        }
        return relUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE || exchange.getStatus() == ExchangeStatus.ERROR) {
            PostMethod method = this.methods.remove(exchange.getExchangeId());
            if (method != null) {
                method.releaseConnection();
            }
            return;
        }
        boolean txSync = exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
        txSync |= this.endpoint.isSynchronous();
        NormalizedMessage nm = exchange.getMessage("in");
        if (nm == null) {
            throw new IllegalStateException("Exchange has no input message");
        }
        String locationURI = this.endpoint.getLocationURI();
        Object newDestinationURI = nm.getProperty("org.apache.servicemix.http.destination.uri");
        if (newDestinationURI != null) {
            locationURI = (String)newDestinationURI;
            log.debug((Object)("Location URI overridden: " + locationURI));
        }
        PostMethod method = new PostMethod(this.getRelUri(locationURI));
        SoapMessage soapMessage = new SoapMessage();
        this.soapHelper.getJBIMarshaler().fromNMS(soapMessage, nm);
        Context context = this.soapHelper.createContext(soapMessage);
        this.soapHelper.onSend(context);
        SoapWriter writer = this.soapHelper.getSoapMarshaler().createWriter(soapMessage);
        this.copyHeaderInformation(nm, method);
        RequestEntity entity = this.writeMessage(writer);
        if (!this.endpoint.isWantContentTypeHeaderFromExchangeIntoHttpRequest()) {
            method.removeRequestHeader("Content-Type");
            method.addRequestHeader("Content-Type", entity.getContentType());
        }
        if (entity.getContentLength() < 0L) {
            method.removeRequestHeader("Content-Length");
        } else {
            method.setRequestHeader("Content-Length", Long.toString(entity.getContentLength()));
        }
        if (this.endpoint.isSoap() && method.getRequestHeader("SOAPAction") == null) {
            if (this.endpoint.getSoapAction() != null) {
                method.setRequestHeader("SOAPAction", this.endpoint.getSoapAction());
            } else {
                method.setRequestHeader("SOAPAction", "\"\"");
            }
        }
        method.setRequestEntity(entity);
        boolean close = true;
        try {
            int response;
            int retries = this.getConfiguration().isStreamingEnabled() ? 0 : this.getConfiguration().getRetryCount();
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retries, true));
            if (this.endpoint.getBasicAuthentication() != null) {
                this.endpoint.getBasicAuthentication().applyCredentials(this.getClient(), exchange, nm);
            }
            if ((response = this.getClient().executeMethod(this.getHostConfiguration(locationURI, exchange, nm), (HttpMethod)method)) != 200 && response != 202) {
                if (!(exchange instanceof InOnly)) {
                    SoapReader reader = this.soapHelper.getSoapMarshaler().createReader();
                    Header contentType = method.getResponseHeader("Content-Type");
                    soapMessage = reader.read(method.getResponseBodyAsStream(), contentType != null ? contentType.getValue() : null);
                    context.setFaultMessage(soapMessage);
                    this.soapHelper.onAnswer(context);
                    Fault fault = exchange.createFault();
                    fault.setProperty("javax.jbi.messaging.protocol.headers", this.getHeaders((HttpMethod)method));
                    this.soapHelper.getJBIMarshaler().toNMS((NormalizedMessage)fault, soapMessage);
                    exchange.setFault(fault);
                    if (txSync) {
                        this.channel.sendSync(exchange);
                    } else {
                        this.methods.put(exchange.getExchangeId(), method);
                        this.channel.send(exchange);
                        close = false;
                    }
                    return;
                }
                throw new Exception("Invalid status response: " + response);
            }
            if (exchange instanceof InOut) {
                close = this.processInOut(exchange, method, context, txSync, close);
            } else if (exchange instanceof InOptionalOut) {
                close = this.processInOptionalOut(method, exchange, context, txSync, close);
            } else {
                exchange.setStatus(ExchangeStatus.DONE);
                this.channel.send(exchange);
            }
        }
        finally {
            if (close) {
                method.releaseConnection();
            }
        }
    }

    private void copyHeaderInformation(NormalizedMessage nm, PostMethod method) {
        Map headers = (Map)nm.getProperty("javax.jbi.messaging.protocol.headers");
        if (headers != null) {
            for (String name : headers.keySet()) {
                String value = (String)headers.get(name);
                method.addRequestHeader(name, value);
            }
        }
    }

    private boolean processInOptionalOut(PostMethod method, MessageExchange exchange, Context context, boolean txSync, boolean close) throws Exception {
        if (method.getResponseContentLength() == 0L) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.channel.send(exchange);
        } else {
            NormalizedMessage msg = exchange.createMessage();
            SoapReader reader = this.soapHelper.getSoapMarshaler().createReader();
            SoapMessage soapMessage = reader.read(method.getResponseBodyAsStream(), method.getResponseHeader("Content-Type").getValue());
            context.setOutMessage(soapMessage);
            this.soapHelper.onAnswer(context);
            if (this.getConfiguration().isWantHeadersFromHttpIntoExchange()) {
                msg.setProperty("javax.jbi.messaging.protocol.headers", this.getHeaders((HttpMethod)method));
            }
            this.soapHelper.getJBIMarshaler().toNMS(msg, soapMessage);
            ((InOptionalOut)exchange).setOutMessage(msg);
            if (txSync) {
                this.channel.sendSync(exchange);
            } else {
                this.methods.put(exchange.getExchangeId(), method);
                this.channel.send(exchange);
                close = false;
            }
        }
        return close;
    }

    private boolean processInOut(MessageExchange exchange, PostMethod method, Context context, boolean txSync, boolean close) throws Exception {
        NormalizedMessage msg = exchange.createMessage();
        SoapReader reader = this.soapHelper.getSoapMarshaler().createReader();
        Header contentType = method.getResponseHeader("Content-Type");
        SoapMessage soapMessage = reader.read(method.getResponseBodyAsStream(), contentType != null ? contentType.getValue() : null);
        context.setOutMessage(soapMessage);
        this.soapHelper.onAnswer(context);
        if (this.getConfiguration().isWantHeadersFromHttpIntoExchange()) {
            msg.setProperty("javax.jbi.messaging.protocol.headers", this.getHeaders((HttpMethod)method));
        }
        this.soapHelper.getJBIMarshaler().toNMS(msg, soapMessage);
        ((InOut)exchange).setOutMessage(msg);
        if (txSync) {
            this.channel.sendSync(exchange);
        } else {
            this.methods.put(exchange.getExchangeId(), method);
            this.channel.send(exchange);
            close = false;
        }
        return close;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostConfiguration getHostConfiguration(String locationURI, MessageExchange exchange, NormalizedMessage message) throws Exception {
        HostConfiguration host;
        URI uri = new URI(locationURI, false);
        if (uri.getScheme().equals("https")) {
            ProviderProcessor providerProcessor = this;
            synchronized (providerProcessor) {
                if (this.protocol == null) {
                    CommonsHttpSSLSocketFactory sf = new CommonsHttpSSLSocketFactory(this.endpoint.getSsl(), this.endpoint.getKeystoreManager());
                    this.protocol = new Protocol("https", (ProtocolSocketFactory)sf, 443);
                }
            }
            HttpHost httphost = new HttpHost(uri.getHost(), uri.getPort(), this.protocol);
            host = new HostConfiguration();
            host.setHost(httphost);
        } else {
            host = new HostConfiguration();
            host.setHost(uri.getHost(), uri.getPort());
        }
        if (this.endpoint.getProxy() != null) {
            if (this.endpoint.getProxy().getProxyHost() != null && this.endpoint.getProxy().getProxyPort() != 0) {
                host.setProxy(this.endpoint.getProxy().getProxyHost(), this.endpoint.getProxy().getProxyPort());
            }
            if (this.endpoint.getProxy().getProxyCredentials() != null) {
                this.endpoint.getProxy().getProxyCredentials().applyProxyCredentials(this.getClient(), exchange, message);
            }
        } else if (this.getConfiguration().getProxyHost() != null && this.getConfiguration().getProxyPort() != 0) {
            host.setProxy(this.getConfiguration().getProxyHost(), this.getConfiguration().getProxyPort());
        }
        return host;
    }

    public void start() throws Exception {
        this.channel = this.endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
    }

    public void stop() throws Exception {
    }

    protected Map<String, String> getHeaders(HttpServletRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = request.getHeader(name);
            headers.put(name, value);
        }
        return headers;
    }

    protected Map<String, String> getHeaders(HttpMethod method) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Header[] h = method.getResponseHeaders();
        for (int i = 0; i < h.length; ++i) {
            headers.put(h[i].getName(), h[i].getValue());
        }
        return headers;
    }

    protected RequestEntity writeMessage(SoapWriter writer) throws Exception {
        if (this.getConfiguration().isStreamingEnabled()) {
            return new StreamingRequestEntity(writer);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write((OutputStream)baos);
        return new ByteArrayRequestEntity(baos.toByteArray(), writer.getContentType());
    }

    protected HttpClient getClient() {
        HttpComponent comp = (HttpComponent)this.endpoint.getServiceUnit().getComponent();
        return comp.getClient();
    }

    public static class StreamingRequestEntity
    implements RequestEntity {
        private SoapWriter writer;

        public StreamingRequestEntity(SoapWriter writer) {
            this.writer = writer;
        }

        public boolean isRepeatable() {
            return false;
        }

        public void writeRequest(OutputStream out) throws IOException {
            try {
                this.writer.write(out);
                out.flush();
            }
            catch (Exception e) {
                throw (IOException)new IOException("Could not write request").initCause(e);
            }
        }

        public long getContentLength() {
            return -1L;
        }

        public String getContentType() {
            return this.writer.getContentType();
        }
    }
}

