/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.expression;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;

public class MessageVariableResolver
implements XPathVariableResolver {
    public static final String SYSTEM_PROPERTIES_NAMESPACE = "http://servicemix.org/xml/variables/system-properties";
    public static final String ENVIRONMENT_VARIABLES = "http://servicemix.org/xml/variables/environment-variables";
    private MessageExchange exchange;
    private NormalizedMessage message;

    public MessageExchange getExchange() {
        return this.exchange;
    }

    public void setExchange(MessageExchange exchange) {
        this.exchange = exchange;
    }

    public NormalizedMessage getMessage() {
        return this.message;
    }

    public void setMessage(NormalizedMessage message) {
        this.message = message;
    }

    public Object resolveVariable(QName name) {
        String uri = name.getNamespaceURI();
        String localPart = name.getLocalPart();
        Object answer = null;
        if (uri == null || uri.length() == 0) {
            answer = this.message.getProperty(localPart);
            if (answer == null) {
                answer = this.exchange.getProperty(localPart);
            }
        } else if (uri.equals(SYSTEM_PROPERTIES_NAMESPACE)) {
            answer = System.getProperty(localPart);
        } else if (uri.equals(ENVIRONMENT_VARIABLES)) {
            answer = System.getProperty(System.getProperty(localPart));
        }
        return answer;
    }
}

