/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.route.time;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.route.time.exception.TimeServiceInitException;

public final class TimeServiceConfiguration {
    private static final TimeServiceConfiguration CONFIG = new TimeServiceConfiguration();
    private String driverClassName;
    private DataSource dataSource;

    private TimeServiceConfiguration() {
        this.init();
    }

    private void init() {
        try (InputStream inputStream = TimeServiceConfiguration.class.getResourceAsStream("/time-service.properties");){
            Properties properties = new Properties();
            properties.load(inputStream);
            String dataSourceType = (String)properties.remove("dataSourceType");
            this.driverClassName = (String)properties.get("driverClassName");
            Class<?> dataSourceClass = Class.forName(dataSourceType);
            this.dataSource = (DataSource)dataSourceClass.newInstance();
            for (String each : properties.stringPropertyNames()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(each, dataSourceClass);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                writeMethod.invoke((Object)this.dataSource, properties.getProperty(each));
            }
        }
        catch (IntrospectionException | IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new TimeServiceInitException("please check your time-service.properties", ex);
        }
    }

    public static TimeServiceConfiguration getInstance() {
        return CONFIG;
    }

    @Generated
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

