/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.spring.namespace.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.shardingjdbc.orchestration.spring.datasource.OrchestrationSpringEncryptDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.spring.datasource.OrchestrationSpringMasterSlaveDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.spring.datasource.OrchestrationSpringShardingDataSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public final class DataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(this.getOrchestrationDataSourceClass(element.getLocalName()));
        this.configureFactory(element, factory);
        return factory.getBeanDefinition();
    }

    private Class<?> getOrchestrationDataSourceClass(String localName) {
        switch (localName) {
            case "sharding-data-source": {
                return OrchestrationSpringShardingDataSource.class;
            }
            case "encrypt-data-source": {
                return OrchestrationSpringEncryptDataSource.class;
            }
        }
        return OrchestrationSpringMasterSlaveDataSource.class;
    }

    private void configureFactory(Element element, BeanDefinitionBuilder factory) {
        String dataSourceName = element.getAttribute("data-source-ref");
        if (!Strings.isNullOrEmpty((String)dataSourceName)) {
            factory.addConstructorArgReference(dataSourceName);
        }
        factory.addConstructorArgValue((Object)this.getOrchestrationConfiguration(element));
    }

    private BeanDefinition getOrchestrationConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(OrchestrationConfiguration.class);
        factory.addConstructorArgValue(this.parseInstances(element));
        return factory.getBeanDefinition();
    }

    private Map<String, RuntimeBeanReference> parseInstances(Element element) {
        List instances = Splitter.on((String)",").trimResults().splitToList((CharSequence)element.getAttribute("instance-ref"));
        ManagedMap result = new ManagedMap(instances.size());
        for (String each : instances) {
            result.put(each, new RuntimeBeanReference(each));
        }
        return result;
    }
}

