/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.center.yaml.config.YamlCenterRepositoryConfiguration;
import org.apache.shardingsphere.orchestration.core.common.rule.OrchestrationShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.OrchestrationShardingDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.YamlCenterRepositoryConfigurationSwapperUtil;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.yaml.YamlOrchestrationShardingRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.yaml.constructor.YamlOrchestrationShardingRuleConfigurationConstructor;
import org.apache.shardingsphere.underlying.common.yaml.engine.YamlEngine;
import org.yaml.snakeyaml.constructor.Constructor;

public final class YamlOrchestrationShardingDataSourceFactory {
    private static final ShardingRuleConfigurationYamlSwapper SHARDING_RULE_SWAPPER = new ShardingRuleConfigurationYamlSwapper();

    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(config.getDataSources(), config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlFile);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(dataSourceMap, config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(config.getDataSources(), config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlOrchestrationShardingRuleConfiguration config = YamlOrchestrationShardingDataSourceFactory.unmarshal(yamlBytes);
        return YamlOrchestrationShardingDataSourceFactory.createDataSource(dataSourceMap, config.getShardingRule(), config.getProps(), config.getOrchestration());
    }

    private static DataSource createDataSource(Map<String, DataSource> dataSourceMap, YamlShardingRuleConfiguration yamlShardingRuleConfiguration, Properties props, Map<String, YamlCenterRepositoryConfiguration> yamlInstanceConfigurationMap) throws SQLException {
        if (null == yamlShardingRuleConfiguration) {
            return new OrchestrationShardingDataSource(new OrchestrationConfiguration(YamlCenterRepositoryConfigurationSwapperUtil.marshal(yamlInstanceConfigurationMap)));
        }
        ShardingDataSource shardingDataSource = new ShardingDataSource(dataSourceMap, (ShardingRule)new OrchestrationShardingRule(SHARDING_RULE_SWAPPER.swap(yamlShardingRuleConfiguration), dataSourceMap.keySet()), props);
        return new OrchestrationShardingDataSource(shardingDataSource, new OrchestrationConfiguration(YamlCenterRepositoryConfigurationSwapperUtil.marshal(yamlInstanceConfigurationMap)));
    }

    private static YamlOrchestrationShardingRuleConfiguration unmarshal(File yamlFile) throws IOException {
        return (YamlOrchestrationShardingRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlOrchestrationShardingRuleConfiguration.class, (Constructor)new YamlOrchestrationShardingRuleConfigurationConstructor());
    }

    private static YamlOrchestrationShardingRuleConfiguration unmarshal(byte[] yamlBytes) throws IOException {
        return (YamlOrchestrationShardingRuleConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlOrchestrationShardingRuleConfiguration.class, (Constructor)new YamlOrchestrationShardingRuleConfigurationConstructor());
    }

    @Generated
    private YamlOrchestrationShardingDataSourceFactory() {
    }
}

