/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.orchestration.core.common.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.core.facade.ShardingOrchestrationFacade;
import org.apache.shardingsphere.orchestration.core.registrycenter.event.CircuitStateChangedEvent;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.circuit.datasource.CircuitBreakerDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;
import org.apache.shardingsphere.underlying.common.config.DataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;

public abstract class AbstractOrchestrationDataSource
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    private PrintWriter logWriter = new PrintWriter(System.out);
    private final ShardingOrchestrationFacade shardingOrchestrationFacade;
    private boolean isCircuitBreak;
    private final Map<String, DataSourceConfiguration> dataSourceConfigurations = new LinkedHashMap<String, DataSourceConfiguration>();

    public AbstractOrchestrationDataSource(ShardingOrchestrationFacade shardingOrchestrationFacade) {
        this.shardingOrchestrationFacade = shardingOrchestrationFacade;
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    protected abstract DataSource getDataSource();

    public final Connection getConnection() throws SQLException {
        return this.isCircuitBreak ? new CircuitBreakerDataSource().getConnection() : this.getDataSource().getConnection();
    }

    public final Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    public final Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public final void close() throws Exception {
        ((AbstractDataSourceAdapter)this.getDataSource()).close();
        this.shardingOrchestrationFacade.close();
    }

    @Subscribe
    public final synchronized void renew(CircuitStateChangedEvent circuitStateChangedEvent) {
        this.isCircuitBreak = circuitStateChangedEvent.isCircuitBreak();
    }

    protected final void initShardingOrchestrationFacade() {
        this.shardingOrchestrationFacade.init();
        this.dataSourceConfigurations.putAll(this.shardingOrchestrationFacade.getConfigCenter().loadDataSourceConfigurations("logic_db"));
    }

    protected final void initShardingOrchestrationFacade(Map<String, Map<String, DataSourceConfiguration>> dataSourceConfigurations, Map<String, RuleConfiguration> schemaRuleMap, Properties props) {
        this.shardingOrchestrationFacade.init(dataSourceConfigurations, schemaRuleMap, null, props);
        this.dataSourceConfigurations.putAll(dataSourceConfigurations.get("logic_db"));
    }

    protected final synchronized Map<String, DataSource> getChangedDataSources(Map<String, DataSource> oldDataSources, Map<String, DataSourceConfiguration> newDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(oldDataSources);
        Map<String, DataSourceConfiguration> modifiedDataSources = this.getModifiedDataSources(newDataSources);
        result.keySet().removeAll(this.getDeletedDataSources(newDataSources));
        result.keySet().removeAll(modifiedDataSources.keySet());
        result.putAll(DataSourceConverter.getDataSourceMap(modifiedDataSources));
        result.putAll(DataSourceConverter.getDataSourceMap(this.getAddedDataSources(newDataSources)));
        return result;
    }

    protected final synchronized Map<String, DataSourceConfiguration> getModifiedDataSources(Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        return dataSourceConfigurations.entrySet().stream().filter(this::isModifiedDataSource).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (key, repeatKey) -> key, LinkedHashMap::new));
    }

    private synchronized boolean isModifiedDataSource(Map.Entry<String, DataSourceConfiguration> dataSourceNameAndConfig) {
        return this.dataSourceConfigurations.containsKey(dataSourceNameAndConfig.getKey()) && !this.dataSourceConfigurations.get(dataSourceNameAndConfig.getKey()).equals((Object)dataSourceNameAndConfig.getValue());
    }

    protected final synchronized List<String> getDeletedDataSources(Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        LinkedList<String> result = new LinkedList<String>(this.dataSourceConfigurations.keySet());
        result.removeAll(dataSourceConfigurations.keySet());
        return result;
    }

    private synchronized Map<String, DataSourceConfiguration> getAddedDataSources(Map<String, DataSourceConfiguration> dataSourceConfigurations) {
        return Maps.filterEntries(dataSourceConfigurations, input -> !this.dataSourceConfigurations.containsKey(input.getKey()));
    }

    @Generated
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    @Generated
    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    @Generated
    protected ShardingOrchestrationFacade getShardingOrchestrationFacade() {
        return this.shardingOrchestrationFacade;
    }

    @Generated
    protected Map<String, DataSourceConfiguration> getDataSourceConfigurations() {
        return this.dataSourceConfigurations;
    }
}

