/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.orchestration.center.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.core.common.event.DataSourceChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.PropertiesChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.event.ShardingRuleChangedEvent;
import org.apache.shardingsphere.orchestration.core.common.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.orchestration.core.common.rule.OrchestrationShardingRule;
import org.apache.shardingsphere.orchestration.core.configcenter.ConfigCenter;
import org.apache.shardingsphere.orchestration.core.facade.ShardingOrchestrationFacade;
import org.apache.shardingsphere.orchestration.core.registrycenter.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.core.registrycenter.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.AbstractOrchestrationDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;

public class OrchestrationShardingDataSource
extends AbstractOrchestrationDataSource {
    private ShardingDataSource dataSource;

    public OrchestrationShardingDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        ConfigCenter configService = this.getShardingOrchestrationFacade().getConfigCenter();
        ShardingRuleConfiguration shardingRuleConfig = configService.loadShardingRuleConfiguration("logic_db");
        Preconditions.checkState((null != shardingRuleConfig && !shardingRuleConfig.getTableRuleConfigs().isEmpty() ? 1 : 0) != 0, (Object)"Missing the sharding rule configuration on registry center");
        Map dataSourceConfigurations = configService.loadDataSourceConfigurations("logic_db");
        this.dataSource = new ShardingDataSource(DataSourceConverter.getDataSourceMap(dataSourceConfigurations), (ShardingRule)new OrchestrationShardingRule(shardingRuleConfig, dataSourceConfigurations.keySet()), configService.loadProperties());
        this.initShardingOrchestrationFacade();
    }

    public OrchestrationShardingDataSource(ShardingDataSource shardingDataSource, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        this.dataSource = shardingDataSource;
        this.initShardingOrchestrationFacade(Collections.singletonMap("logic_db", DataSourceConverter.getDataSourceConfigurationMap(this.dataSource.getDataSourceMap())), this.getRuleConfigurationMap(), this.dataSource.getRuntimeContext().getProperties().getProps());
    }

    private Map<String, RuleConfiguration> getRuleConfigurationMap() {
        LinkedHashMap<String, RuleConfiguration> result = new LinkedHashMap<String, RuleConfiguration>(1, 1.0f);
        result.put("logic_db", (RuleConfiguration)((ShardingRule)this.dataSource.getRuntimeContext().getRule()).getRuleConfiguration());
        return result;
    }

    @Subscribe
    public final synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        this.dataSource = new ShardingDataSource(this.dataSource.getDataSourceMap(), (ShardingRule)new OrchestrationShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.dataSource.getDataSourceMap().keySet()), this.dataSource.getRuntimeContext().getProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        Map dataSourceConfigurations = dataSourceChangedEvent.getDataSourceConfigurations();
        this.dataSource.close(this.getDeletedDataSources(dataSourceConfigurations));
        this.dataSource.close(this.getModifiedDataSources(dataSourceConfigurations).keySet());
        this.dataSource = new ShardingDataSource(this.getChangedDataSources(this.dataSource.getDataSourceMap(), dataSourceConfigurations), (ShardingRule)this.dataSource.getRuntimeContext().getRule(), this.dataSource.getRuntimeContext().getProperties().getProps());
        this.getDataSourceConfigurations().clear();
        this.getDataSourceConfigurations().putAll(dataSourceConfigurations);
    }

    @Subscribe
    public final synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.dataSource = new ShardingDataSource(this.dataSource.getDataSourceMap(), (ShardingRule)this.dataSource.getRuntimeContext().getRule(), propertiesChangedEvent.getProps());
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if ("logic_db".equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : ((ShardingRule)this.dataSource.getRuntimeContext().getRule()).getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }

    @Generated
    protected ShardingDataSource getDataSource() {
        return this.dataSource;
    }
}

