/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.boot;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.config.inline.InlineExpressionParser;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.core.yaml.config.encrypt.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlMasterSlaveRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.impl.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.impl.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.core.yaml.swapper.impl.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.api.EncryptDataSourceFactory;
import org.apache.shardingsphere.shardingjdbc.api.MasterSlaveDataSourceFactory;
import org.apache.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;
import org.apache.shardingsphere.shardingjdbc.spring.boot.common.SpringBootPropertiesConfigurationProperties;
import org.apache.shardingsphere.shardingjdbc.spring.boot.encrypt.EncryptRuleCondition;
import org.apache.shardingsphere.shardingjdbc.spring.boot.encrypt.SpringBootEncryptRuleConfigurationProperties;
import org.apache.shardingsphere.shardingjdbc.spring.boot.masterslave.MasterSlaveRuleCondition;
import org.apache.shardingsphere.shardingjdbc.spring.boot.masterslave.SpringBootMasterSlaveRuleConfigurationProperties;
import org.apache.shardingsphere.shardingjdbc.spring.boot.sharding.ShardingRuleCondition;
import org.apache.shardingsphere.shardingjdbc.spring.boot.sharding.SpringBootShardingRuleConfigurationProperties;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetter;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetterHolder;
import org.apache.shardingsphere.spring.boot.util.DataSourceUtil;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jndi.JndiObjectFactoryBean;

@Configuration
@ComponentScan(value={"org.apache.shardingsphere.spring.boot.converter"})
@EnableConfigurationProperties(value={SpringBootShardingRuleConfigurationProperties.class, SpringBootMasterSlaveRuleConfigurationProperties.class, SpringBootEncryptRuleConfigurationProperties.class, SpringBootPropertiesConfigurationProperties.class})
@ConditionalOnProperty(prefix="spring.shardingsphere", name={"enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class SpringBootConfiguration
implements EnvironmentAware {
    private final SpringBootShardingRuleConfigurationProperties shardingRule;
    private final SpringBootMasterSlaveRuleConfigurationProperties masterSlaveRule;
    private final SpringBootEncryptRuleConfigurationProperties encryptRule;
    private final SpringBootPropertiesConfigurationProperties props;
    private final Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private final String jndiName = "jndi-name";

    @Bean
    @Conditional(value={ShardingRuleCondition.class})
    public DataSource shardingDataSource() throws SQLException {
        return ShardingDataSourceFactory.createDataSource(this.dataSourceMap, (ShardingRuleConfiguration)new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)this.shardingRule), (Properties)this.props.getProps());
    }

    @Bean
    @Conditional(value={MasterSlaveRuleCondition.class})
    public DataSource masterSlaveDataSource() throws SQLException {
        return MasterSlaveDataSourceFactory.createDataSource(this.dataSourceMap, (MasterSlaveRuleConfiguration)new MasterSlaveRuleConfigurationYamlSwapper().swap((YamlMasterSlaveRuleConfiguration)this.masterSlaveRule), (Properties)this.props.getProps());
    }

    @Bean
    @Conditional(value={EncryptRuleCondition.class})
    public DataSource encryptDataSource() throws SQLException {
        return EncryptDataSourceFactory.createDataSource((DataSource)this.dataSourceMap.values().iterator().next(), (EncryptRuleConfiguration)new EncryptRuleConfigurationYamlSwapper().swap((YamlEncryptRuleConfiguration)this.encryptRule), (Properties)this.props.getProps());
    }

    public final void setEnvironment(Environment environment) {
        String prefix = "spring.shardingsphere.datasource.";
        for (String each : this.getDataSourceNames(environment, prefix)) {
            try {
                this.dataSourceMap.put(each, this.getDataSource(environment, prefix, each));
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingException("Can't find datasource type!", (Exception)ex);
            }
            catch (NamingException namingEx) {
                throw new ShardingException("Can't find JNDI datasource!", (Exception)namingEx);
            }
        }
    }

    private List<String> getDataSourceNames(Environment environment, String prefix) {
        StandardEnvironment standardEnv = (StandardEnvironment)environment;
        standardEnv.setIgnoreUnresolvableNestedPlaceholders(true);
        return null == standardEnv.getProperty(prefix + "name") ? new InlineExpressionParser(standardEnv.getProperty(prefix + "names")).splitAndEvaluate() : Collections.singletonList(standardEnv.getProperty(prefix + "name"));
    }

    private DataSource getDataSource(Environment environment, String prefix, String dataSourceName) throws ReflectiveOperationException, NamingException {
        Map dataSourceProps = (Map)PropertyUtil.handle((Environment)environment, (String)(prefix + dataSourceName.trim()), Map.class);
        Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (Object)"Wrong datasource properties!");
        if (dataSourceProps.containsKey("jndi-name")) {
            return this.getJndiDataSource(dataSourceProps.get("jndi-name").toString());
        }
        DataSource result = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
        Optional dataSourcePropertiesSetter = DataSourcePropertiesSetterHolder.getDataSourcePropertiesSetterByType((String)dataSourceProps.get("type").toString());
        if (dataSourcePropertiesSetter.isPresent()) {
            ((DataSourcePropertiesSetter)dataSourcePropertiesSetter.get()).propertiesSet(environment, prefix, dataSourceName, result);
        }
        return result;
    }

    private DataSource getJndiDataSource(String jndiName) throws NamingException {
        JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
        bean.setResourceRef(true);
        bean.setJndiName(jndiName);
        bean.setProxyInterface(DataSource.class);
        bean.afterPropertiesSet();
        return (DataSource)bean.getObject();
    }

    @ConstructorProperties(value={"shardingRule", "masterSlaveRule", "encryptRule", "props"})
    public SpringBootConfiguration(SpringBootShardingRuleConfigurationProperties shardingRule, SpringBootMasterSlaveRuleConfigurationProperties masterSlaveRule, SpringBootEncryptRuleConfigurationProperties encryptRule, SpringBootPropertiesConfigurationProperties props) {
        this.shardingRule = shardingRule;
        this.masterSlaveRule = masterSlaveRule;
        this.encryptRule = encryptRule;
        this.props = props;
    }
}

