/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.api.config.encryptor.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.encryptor.EncryptorRuleConfiguration;
import org.apache.shardingsphere.shardingjdbc.spring.datasource.SpringEncryptDataSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class EncryptDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringEncryptDataSource.class);
        factory.addConstructorArgValue((Object)this.parseDataSource(element));
        factory.addConstructorArgValue((Object)this.parseEncryptRuleConfiguration(element));
        factory.setDestroyMethodName("close");
        return factory.getBeanDefinition();
    }

    private RuntimeBeanReference parseDataSource(Element element) {
        String dataSource = element.getAttribute("data-source-name");
        return new RuntimeBeanReference(dataSource);
    }

    private BeanDefinition parseEncryptRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptRuleConfiguration.class);
        factory.addConstructorArgValue(this.parseEncryptorRulesConfiguration(element));
        return factory.getBeanDefinition();
    }

    private Map<String, BeanDefinition> parseEncryptorRulesConfiguration(Element element) {
        List encryptorRuleElements = DomUtils.getChildElementsByTagName((Element)element, (String)"encryptor-rule");
        ManagedMap result = new ManagedMap(encryptorRuleElements.size());
        for (Element each : encryptorRuleElements) {
            result.put(each.getAttribute("id"), this.parseEncryptorRuleConfiguration(each));
        }
        return result;
    }

    private AbstractBeanDefinition parseEncryptorRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptorRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("type"));
        factory.addConstructorArgValue((Object)element.getAttribute("qualified-columns"));
        this.parseAssistedQueryColumns(element, factory);
        this.parseProperties(element, factory);
        return factory.getBeanDefinition();
    }

    private void parseAssistedQueryColumns(Element element, BeanDefinitionBuilder factory) {
        String assistedQueryColumns = element.getAttribute("assisted-query-columns");
        if (!Strings.isNullOrEmpty((String)assistedQueryColumns)) {
            factory.addConstructorArgValue((Object)assistedQueryColumns);
        }
    }

    private void parseProperties(Element element, BeanDefinitionBuilder factory) {
        String properties = element.getAttribute("props-ref");
        if (!Strings.isNullOrEmpty((String)properties)) {
            factory.addConstructorArgReference(properties);
        } else {
            factory.addConstructorArgValue((Object)new Properties());
        }
    }
}

