/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import java.util.Properties;
import org.apache.shardingsphere.shardingjdbc.spring.datasource.SpringEncryptDataSource;
import org.apache.shardingsphere.shardingjdbc.spring.namespace.parser.EncryptRuleBeanDefinitionParser;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class EncryptDataSourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(SpringEncryptDataSource.class);
        factory.addConstructorArgValue((Object)this.parseDataSource(element));
        factory.addConstructorArgValue((Object)this.parseEncryptRuleConfiguration(element));
        factory.addConstructorArgValue((Object)this.parseProperties(element, parserContext));
        factory.setDestroyMethodName("close");
        return factory.getBeanDefinition();
    }

    private RuntimeBeanReference parseDataSource(Element element) {
        String dataSource = element.getAttribute("data-source-name");
        return new RuntimeBeanReference(dataSource);
    }

    private AbstractBeanDefinition parseEncryptRuleConfiguration(Element element) {
        Element encryptRuleElement = DomUtils.getChildElementByTagName((Element)element, (String)"encrypt-rule");
        return EncryptRuleBeanDefinitionParser.parseEncryptRuleElement(encryptRuleElement);
    }

    private Properties parseProperties(Element element, ParserContext parserContext) {
        Element propsElement = DomUtils.getChildElementByTagName((Element)element, (String)"props");
        return null == propsElement ? new Properties() : parserContext.getDelegate().parsePropsElement(propsElement);
    }
}

