/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.w3c.dom.Element;

public final class MasterSlaveRuleConfigurationBeanDefinition {
    private static final String MASTER_DATA_SOURCE_NAME_ATTRIBUTE = "master-data-source-name";
    private static final String SLAVE_DATA_SOURCE_NAMES_ATTRIBUTE = "slave-data-source-names";
    private static final String LOAD_BALANCE_ALGORITHM_REF_ATTRIBUTE = "strategy-ref";
    private String masterDataSourceName;
    private String slaveDataSourceNames;
    private BeanDefinition beanDefinition;

    public MasterSlaveRuleConfigurationBeanDefinition(Element element) {
        this.masterDataSourceName = element.getAttribute(MASTER_DATA_SOURCE_NAME_ATTRIBUTE);
        this.slaveDataSourceNames = element.getAttribute(SLAVE_DATA_SOURCE_NAMES_ATTRIBUTE);
        this.beanDefinition = this.getBeanDefinition(element);
    }

    private BeanDefinition getBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(MasterSlaveRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("id"));
        factory.addConstructorArgValue((Object)this.masterDataSourceName);
        factory.addConstructorArgValue(this.parseSlaveDataSourcesRef());
        this.parseMasterSlaveRuleLoadBalanceConfiguration(element, factory);
        return factory.getBeanDefinition();
    }

    private void parseMasterSlaveRuleLoadBalanceConfiguration(Element element, BeanDefinitionBuilder factory) {
        String loadBalanceStrategyConfiguration = element.getAttribute(LOAD_BALANCE_ALGORITHM_REF_ATTRIBUTE);
        if (!Strings.isNullOrEmpty((String)loadBalanceStrategyConfiguration)) {
            factory.addConstructorArgReference(loadBalanceStrategyConfiguration);
        }
    }

    private Collection<String> parseSlaveDataSourcesRef() {
        List slaveDataSources = Splitter.on((String)",").trimResults().splitToList((CharSequence)this.slaveDataSourceNames);
        ManagedList result = new ManagedList(slaveDataSources.size());
        result.addAll(slaveDataSources);
        return result;
    }

    @Generated
    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    @Generated
    public String getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    @Generated
    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }
}

