/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.center.instance;

import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.instance.ApolloProperties;
import org.apache.shardingsphere.orchestration.center.instance.wrapper.ApolloConfigWrapper;
import org.apache.shardingsphere.orchestration.center.instance.wrapper.ApolloOpenApiWrapper;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEventListener;
import org.apache.shardingsphere.orchestration.center.util.ConfigKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApolloCenterRepository
implements ConfigCenterRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApolloCenterRepository.class);
    private final Map<String, DataChangedEventListener> caches = new HashMap<String, DataChangedEventListener>();
    private ApolloConfigWrapper configWrapper;
    private ApolloOpenApiWrapper openApiWrapper;
    private Properties properties = new Properties();

    public void init(CenterConfiguration config) {
        ApolloProperties apolloProperties = new ApolloProperties(this.properties);
        this.configWrapper = new ApolloConfigWrapper(config, apolloProperties);
        this.openApiWrapper = new ApolloOpenApiWrapper(config, apolloProperties);
    }

    public String get(String key) {
        String value = this.configWrapper.getProperty(ConfigKeyUtils.path2Key((String)key));
        return Strings.isNullOrEmpty((String)value) ? this.openApiWrapper.getValue(ConfigKeyUtils.path2Key((String)key)) : value;
    }

    public List<String> getChildrenKeys(String key) {
        return null;
    }

    public void persist(String key, String value) {
        try {
            this.openApiWrapper.persist(ConfigKeyUtils.path2Key((String)key), value);
        }
        catch (Exception ex) {
            log.error("Apollo persist key '{}' throw exception: {}", (Object)key, (Object)ex);
        }
    }

    public void watch(String key, DataChangedEventListener dataChangedEventListener) {
        String apolloKey = ConfigKeyUtils.path2Key((String)key);
        this.caches.put(apolloKey, dataChangedEventListener);
        ConfigChangeListener listener = changeEvent -> {
            for (String changeKey : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(changeKey);
                DataChangedEvent.ChangedType changedType = this.getChangedType(change.getChangeType());
                if (DataChangedEvent.ChangedType.IGNORED == changedType || this.caches.get(changeKey) == null) continue;
                this.caches.get(changeKey).onChange(new DataChangedEvent(ConfigKeyUtils.key2Path((String)changeKey), change.getNewValue(), changedType));
            }
        };
        this.configWrapper.addChangeListener(listener, Collections.singleton(apolloKey), Collections.singleton(apolloKey));
    }

    private DataChangedEvent.ChangedType getChangedType(PropertyChangeType changeType) {
        switch (changeType) {
            case ADDED: 
            case MODIFIED: {
                return DataChangedEvent.ChangedType.UPDATED;
            }
            case DELETED: {
                return DataChangedEvent.ChangedType.DELETED;
            }
        }
        return DataChangedEvent.ChangedType.IGNORED;
    }

    public void close() {
    }

    public String getType() {
        return "apollo";
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

