/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.center.instance.wrapper;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import java.util.Set;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.instance.ApolloProperties;
import org.apache.shardingsphere.orchestration.center.instance.ApolloPropertyKey;

public final class ApolloConfigWrapper {
    private static final String APOLLO_KEY_APP_ID = "app.id";
    private static final String APOLLO_KEY_ENV = "env";
    private Config apolloConfig;

    public ApolloConfigWrapper(CenterConfiguration config, ApolloProperties properties) {
        String appId = (String)properties.getValue(ApolloPropertyKey.APP_ID);
        String env = (String)properties.getValue(ApolloPropertyKey.ENV);
        String clusterName = (String)properties.getValue(ApolloPropertyKey.CLUSTER_NAME);
        System.setProperty(APOLLO_KEY_APP_ID, appId);
        System.setProperty(APOLLO_KEY_ENV, env);
        System.setProperty("apollo.cluster", clusterName);
        System.setProperty("apollo.meta", config.getServerLists());
        String namespace = config.getNamespace();
        this.apolloConfig = ConfigService.getConfig((String)namespace);
    }

    public String getProperty(String key) {
        return this.apolloConfig.getProperty(key, "");
    }

    public void addChangeListener(ConfigChangeListener listener, Set<String> interestedKeys) {
        this.apolloConfig.addChangeListener(listener, interestedKeys);
    }

    public void addChangeListener(ConfigChangeListener listener, Set<String> interestedKeys, Set<String> interestedKeyPrefixes) {
        this.apolloConfig.addChangeListener(listener, interestedKeys, interestedKeyPrefixes);
    }
}

