/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.SQLType;
import org.apache.shardingsphere.core.merge.MergeEngineFactory;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowTablesMergedResult;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.old.parser.constant.DerivedColumn;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.ConnectionStatus;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.JDBCExecuteEngine;
import org.apache.shardingsphere.shardingproxy.backend.exception.TableModifyInTransactionException;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.TransparentSchema;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class JDBCDatabaseCommunicationEngine
implements DatabaseCommunicationEngine {
    private final LogicSchema logicSchema;
    private final String sql;
    private final JDBCExecuteEngine executeEngine;
    private final DatabaseType databaseType = LogicSchemas.getInstance().getDatabaseType();
    private BackendResponse response;
    private MergedResult mergedResult;

    @Override
    public BackendResponse execute() {
        try {
            SQLRouteResult routeResult = this.executeEngine.getJdbcExecutorWrapper().route(this.sql, this.databaseType);
            return this.execute(routeResult);
        }
        catch (SQLException ex) {
            return new ErrorResponse(ex);
        }
    }

    private BackendResponse execute(SQLRouteResult routeResult) throws SQLException {
        if (routeResult.getRouteUnits().isEmpty()) {
            return new UpdateResponse();
        }
        SQLStatement sqlStatement = routeResult.getSqlStatement();
        if (this.isExecuteDDLInXATransaction(sqlStatement.getType())) {
            return new ErrorResponse(new TableModifyInTransactionException(sqlStatement.getTables().isSingleTable() ? sqlStatement.getTables().getSingleTableName() : "unknown_table"));
        }
        this.response = this.executeEngine.execute(routeResult);
        if (this.logicSchema instanceof ShardingSchema) {
            this.logicSchema.refreshTableMetaData(routeResult.getSqlStatement());
        }
        return this.merge(routeResult);
    }

    private boolean isExecuteDDLInXATransaction(SQLType sqlType) {
        BackendConnection connection = this.executeEngine.getBackendConnection();
        return TransactionType.XA == connection.getTransactionType() && SQLType.DDL == sqlType && ConnectionStatus.TRANSACTION == connection.getStateHandler().getStatus();
    }

    private BackendResponse merge(SQLRouteResult routeResult) throws SQLException {
        if (this.response instanceof UpdateResponse) {
            if (!this.isAllBroadcastTables(routeResult.getSqlStatement())) {
                ((UpdateResponse)this.response).mergeUpdateCount();
            }
            return this.response;
        }
        this.mergedResult = MergeEngineFactory.newInstance((DatabaseType)this.databaseType, (ShardingRule)this.getShardingRule(), (SQLRouteResult)routeResult, (ShardingTableMetaData)this.logicSchema.getMetaData().getTable(), ((QueryResponse)this.response).getQueryResults()).merge();
        if (this.mergedResult instanceof ShowTablesMergedResult) {
            ((ShowTablesMergedResult)this.mergedResult).resetColumnLabel(this.logicSchema.getName());
        }
        return this.getQueryHeaderResponseWithoutDerivedColumns(((QueryResponse)this.response).getQueryHeaders());
    }

    private boolean isAllBroadcastTables(SQLStatement sqlStatement) {
        return this.logicSchema instanceof ShardingSchema && ((ShardingSchema)this.logicSchema).getShardingRule().isAllBroadcastTables(sqlStatement.getTables().getTableNames());
    }

    private ShardingRule getShardingRule() {
        ShardingRule result = this.logicSchema instanceof ShardingSchema ? ((ShardingSchema)this.logicSchema).getShardingRule() : (this.logicSchema instanceof MasterSlaveSchema ? ((MasterSlaveSchema)this.logicSchema).getDefaultShardingRule() : ((TransparentSchema)this.logicSchema).getDefaultShardingRule());
        return result;
    }

    private QueryResponse getQueryHeaderResponseWithoutDerivedColumns(List<QueryHeader> queryHeaders) {
        LinkedList<QueryHeader> derivedColumnQueryHeaders = new LinkedList<QueryHeader>();
        for (QueryHeader each : queryHeaders) {
            if (!DerivedColumn.isDerivedColumn((String)each.getColumnLabel())) continue;
            derivedColumnQueryHeaders.add(each);
        }
        queryHeaders.removeAll(derivedColumnQueryHeaders);
        return new QueryResponse(queryHeaders);
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        List<QueryHeader> queryHeaders = ((QueryResponse)this.response).getQueryHeaders();
        ArrayList<Object> row = new ArrayList<Object>(queryHeaders.size());
        for (int columnIndex = 1; columnIndex <= queryHeaders.size(); ++columnIndex) {
            row.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return new QueryData(this.getColumnTypes(queryHeaders), row);
    }

    private List<Integer> getColumnTypes(List<QueryHeader> queryHeaders) {
        ArrayList<Integer> result = new ArrayList<Integer>(queryHeaders.size());
        for (QueryHeader each : queryHeaders) {
            result.add(each.getColumnType());
        }
        return result;
    }

    @ConstructorProperties(value={"logicSchema", "sql", "executeEngine"})
    public JDBCDatabaseCommunicationEngine(LogicSchema logicSchema, String sql, JDBCExecuteEngine executeEngine) {
        this.logicSchema = logicSchema;
        this.sql = sql;
        this.executeEngine = executeEngine;
    }
}

