/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.shardingproxy.backend.BackendDataSource;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCBackendDataSourceFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCRawBackendDataSourceFactory;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;

public final class JDBCBackendDataSource
implements BackendDataSource,
AutoCloseable {
    private Map<String, DataSource> dataSources;
    private JDBCBackendDataSourceFactory dataSourceFactory = JDBCRawBackendDataSourceFactory.getInstance();
    private ShardingTransactionManagerEngine shardingTransactionManagerEngine = new ShardingTransactionManagerEngine();

    public JDBCBackendDataSource(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        this.createDataSourceMap(dataSourceParameters);
    }

    private void createDataSourceMap(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>(dataSourceParameters.size(), 1.0f);
        for (Map.Entry<String, YamlDataSourceParameter> entry : dataSourceParameters.entrySet()) {
            try {
                dataSourceMap.put(entry.getKey(), this.dataSourceFactory.build(entry.getKey(), entry.getValue()));
            }
            catch (Exception ex) {
                throw new ShardingException(String.format("Can not build data source, name is `%s`.", entry.getKey()), ex);
            }
        }
        this.dataSources = dataSourceMap;
        this.shardingTransactionManagerEngine.init(LogicSchemas.getInstance().getDatabaseType(), dataSourceMap);
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        return this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0);
    }

    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        return this.getConnections(connectionMode, dataSourceName, connectionSize, TransactionType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize, TransactionType transactionType) throws SQLException {
        DataSource dataSource = this.dataSources.get(dataSourceName);
        if (1 == connectionSize) {
            return Collections.singletonList(this.createConnection(transactionType, dataSourceName, dataSource));
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(transactionType, dataSourceName, dataSource, connectionSize);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(transactionType, dataSourceName, dataSource, connectionSize);
        }
    }

    private List<Connection> createConnections(TransactionType transactionType, String dataSourceName, DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                result.add(this.createConnection(transactionType, dataSourceName, dataSource));
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Could't get %d connections one time, partition succeed connection(%d) have released!", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    private Connection createConnection(TransactionType transactionType, String dataSourceName, DataSource dataSource) throws SQLException {
        ShardingTransactionManager shardingTransactionManager = this.shardingTransactionManagerEngine.getTransactionManager(transactionType);
        return this.isInShardingTransaction(shardingTransactionManager) ? shardingTransactionManager.getConnection(dataSourceName) : dataSource.getConnection();
    }

    private boolean isInShardingTransaction(ShardingTransactionManager shardingTransactionManager) {
        return null != shardingTransactionManager && shardingTransactionManager.isInTransaction();
    }

    @Override
    public void close() throws Exception {
        if (null != this.dataSources) {
            this.closeDataSource(this.dataSources);
        }
        this.shardingTransactionManagerEngine.close();
    }

    private void closeDataSource(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            try {
                Method method = each.getClass().getDeclaredMethod("close", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    public ShardingTransactionManagerEngine getShardingTransactionManagerEngine() {
        return this.shardingTransactionManagerEngine;
    }
}

