/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCBackendDataSourceFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer.JDBCDriverURLRecognizerEngine;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class JDBCRawBackendDataSourceFactory
implements JDBCBackendDataSourceFactory {
    private static final JDBCRawBackendDataSourceFactory INSTANCE = new JDBCRawBackendDataSourceFactory();

    public static JDBCBackendDataSourceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public DataSource build(String dataSourceName, YamlDataSourceParameter dataSourceParameter) {
        HikariConfig config = new HikariConfig();
        String driverClassName = JDBCDriverURLRecognizerEngine.getDriverClassName(dataSourceParameter.getUrl());
        this.validateDriverClassName(driverClassName);
        config.setDriverClassName(driverClassName);
        config.setJdbcUrl(dataSourceParameter.getUrl());
        config.setUsername(dataSourceParameter.getUsername());
        config.setPassword(dataSourceParameter.getPassword());
        config.setConnectionTimeout(dataSourceParameter.getConnectionTimeoutMilliseconds());
        config.setIdleTimeout(dataSourceParameter.getIdleTimeoutMilliseconds());
        config.setMaxLifetime(dataSourceParameter.getMaxLifetimeMilliseconds());
        config.setMaximumPoolSize(dataSourceParameter.getMaxPoolSize());
        config.setMinimumIdle(dataSourceParameter.getMinPoolSize());
        config.addDataSourceProperty("useServerPrepStmts", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
        config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        config.addDataSourceProperty("useLocalSessionState", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cacheResultSetMetadata", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("cacheServerConfiguration", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("elideSetAutoCommits", (Object)Boolean.TRUE.toString());
        config.addDataSourceProperty("maintainTimeStats", (Object)Boolean.FALSE.toString());
        config.addDataSourceProperty("netTimeoutForStreamingResults", (Object)0);
        return new HikariDataSource(config);
    }

    private void validateDriverClassName(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ShardingException("Cannot load JDBC driver class `%s`, make sure it in Sharding-Proxy's classpath.", new Object[]{driverClassName});
        }
    }

    private JDBCRawBackendDataSourceFactory() {
    }
}

