/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteCallback;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteTemplate;
import org.apache.shardingsphere.core.execute.sql.execute.threadlocal.ExecutorExceptionHandler;
import org.apache.shardingsphere.core.execute.sql.prepare.SQLExecutePrepareCallback;
import org.apache.shardingsphere.core.execute.sql.prepare.SQLExecutePrepareTemplate;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.SQLExecuteEngine;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.callback.ProxyJDBCExecutePrepareCallback;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.callback.ProxySQLExecuteCallback;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteQueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.executor.BackendExecutorContext;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;

public final class JDBCExecuteEngine
implements SQLExecuteEngine {
    private final BackendConnection backendConnection;
    private final JDBCExecutorWrapper jdbcExecutorWrapper;
    private final SQLExecutePrepareTemplate sqlExecutePrepareTemplate;
    private final SQLExecuteTemplate sqlExecuteTemplate;

    public JDBCExecuteEngine(BackendConnection backendConnection, JDBCExecutorWrapper jdbcExecutorWrapper) {
        this.backendConnection = backendConnection;
        this.jdbcExecutorWrapper = jdbcExecutorWrapper;
        int maxConnectionsSizePerQuery = (Integer)ShardingProxyContext.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY);
        this.sqlExecutePrepareTemplate = new SQLExecutePrepareTemplate(maxConnectionsSizePerQuery);
        this.sqlExecuteTemplate = new SQLExecuteTemplate(BackendExecutorContext.getInstance().getExecuteEngine(), backendConnection.isSerialExecute());
    }

    @Override
    public BackendResponse execute(SQLRouteResult routeResult) throws SQLException {
        boolean isReturnGeneratedKeys = routeResult.getSqlStatement() instanceof InsertStatement;
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        Collection sqlExecuteGroups = this.sqlExecutePrepareTemplate.getExecuteUnitGroups(routeResult.getRouteUnits(), (SQLExecutePrepareCallback)new ProxyJDBCExecutePrepareCallback(this.backendConnection, this.jdbcExecutorWrapper, isReturnGeneratedKeys));
        List executeResponses = this.sqlExecuteTemplate.executeGroup(sqlExecuteGroups, (SQLExecuteCallback)new ProxySQLExecuteCallback(this.backendConnection, this.jdbcExecutorWrapper, isExceptionThrown, isReturnGeneratedKeys, true), (SQLExecuteCallback)new ProxySQLExecuteCallback(this.backendConnection, this.jdbcExecutorWrapper, isExceptionThrown, isReturnGeneratedKeys, false));
        ExecuteResponse executeResponse = (ExecuteResponse)executeResponses.iterator().next();
        return executeResponse instanceof ExecuteQueryResponse ? this.getExecuteQueryResponse(((ExecuteQueryResponse)executeResponse).getQueryHeaders(), executeResponses) : new UpdateResponse(executeResponses);
    }

    private BackendResponse getExecuteQueryResponse(List<QueryHeader> queryHeaders, Collection<ExecuteResponse> executeResponses) {
        QueryResponse result = new QueryResponse(queryHeaders);
        for (ExecuteResponse each : executeResponses) {
            result.getQueryResults().add(((ExecuteQueryResponse)each).getQueryResult());
        }
        return result;
    }

    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }

    public JDBCExecutorWrapper getJdbcExecutorWrapper() {
        return this.jdbcExecutorWrapper;
    }
}

