/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.callback;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteCallback;
import org.apache.shardingsphere.core.execute.sql.execute.result.MemoryQueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.StreamQueryResult;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteQueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteUpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.TransparentSchema;

public final class ProxySQLExecuteCallback
extends SQLExecuteCallback<ExecuteResponse> {
    private final BackendConnection backendConnection;
    private final JDBCExecutorWrapper jdbcExecutorWrapper;
    private final boolean isReturnGeneratedKeys;
    private final boolean fetchMetaData;
    private boolean hasMetaData;

    public ProxySQLExecuteCallback(BackendConnection backendConnection, JDBCExecutorWrapper jdbcExecutorWrapper, boolean isExceptionThrown, boolean isReturnGeneratedKeys, boolean fetchMetaData) {
        super(LogicSchemas.getInstance().getDatabaseType(), isExceptionThrown);
        this.backendConnection = backendConnection;
        this.jdbcExecutorWrapper = jdbcExecutorWrapper;
        this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        this.fetchMetaData = fetchMetaData;
    }

    public ExecuteResponse executeSQL(RouteUnit routeUnit, Statement statement, ConnectionMode connectionMode) throws SQLException {
        boolean withMetaData = false;
        if (this.fetchMetaData && !this.hasMetaData) {
            this.hasMetaData = true;
            withMetaData = true;
        }
        return this.executeSQL(statement, routeUnit.getSqlUnit().getSql(), connectionMode, withMetaData);
    }

    private ExecuteResponse executeSQL(Statement statement, String sql, ConnectionMode connectionMode, boolean withMetadata) throws SQLException {
        this.backendConnection.add(statement);
        if (this.jdbcExecutorWrapper.executeSQL(statement, sql, this.isReturnGeneratedKeys)) {
            ResultSet resultSet = statement.getResultSet();
            this.backendConnection.add(resultSet);
            return new ExecuteQueryResponse(withMetadata ? this.getQueryHeaders(resultSet.getMetaData()) : null, this.createQueryResult(resultSet, connectionMode));
        }
        return new ExecuteUpdateResponse(statement.getUpdateCount(), this.isReturnGeneratedKeys ? this.getGeneratedKey(statement) : 0L);
    }

    private List<QueryHeader> getQueryHeaders(ResultSetMetaData resultSetMetaData) throws SQLException {
        LinkedList<QueryHeader> result = new LinkedList<QueryHeader>();
        for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
            result.add(new QueryHeader(resultSetMetaData, this.backendConnection.getLogicSchema(), columnIndex));
        }
        return result;
    }

    private QueryResult createQueryResult(ResultSet resultSet, ConnectionMode connectionMode) {
        LogicSchema logicSchema = this.backendConnection.getLogicSchema();
        if (logicSchema instanceof MasterSlaveSchema || logicSchema instanceof TransparentSchema) {
            return connectionMode == ConnectionMode.MEMORY_STRICTLY ? new StreamQueryResult(resultSet) : new MemoryQueryResult(resultSet);
        }
        ShardingRule shardingRule = ((ShardingSchema)logicSchema).getShardingRule();
        return connectionMode == ConnectionMode.MEMORY_STRICTLY ? new StreamQueryResult(resultSet, shardingRule, shardingRule.getShardingEncryptorEngine()) : new MemoryQueryResult(resultSet, shardingRule, shardingRule.getShardingEncryptorEngine());
    }

    private long getGeneratedKey(Statement statement) throws SQLException {
        ResultSet resultSet = statement.getGeneratedKeys();
        return resultSet.next() ? resultSet.getLong(1) : 0L;
    }
}

