/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer.spi.JDBCDriverURLRecognizer;

public final class JDBCDriverURLRecognizerEngine {
    private static final Map<String, String> URL_PREFIX_AND_DRIVER_CLASS_NAME_MAPPER = new HashMap<String, String>();

    private static void load() {
        for (JDBCDriverURLRecognizer each : ServiceLoader.load(JDBCDriverURLRecognizer.class)) {
            for (String prefix : each.getURLPrefixes()) {
                URL_PREFIX_AND_DRIVER_CLASS_NAME_MAPPER.put(prefix, each.getDriverClassName());
            }
        }
    }

    public static String getDriverClassName(String url) {
        for (Map.Entry<String, String> entry : URL_PREFIX_AND_DRIVER_CLASS_NAME_MAPPER.entrySet()) {
            if (!url.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        throw new ShardingException("Cannot resolve JDBC url `%s`. Please implements `%s` and add to SPI.", new Object[]{url, JDBCDriverURLRecognizer.class.getName()});
    }

    public static DatabaseType getDatabaseType(String url) {
        switch (JDBCDriverURLRecognizerEngine.getDriverClassName(url)) {
            case "com.mysql.cj.jdbc.Driver": 
            case "com.mysql.jdbc.Driver": {
                return DatabaseType.MySQL;
            }
            case "org.postgresql.Driver": {
                return DatabaseType.PostgreSQL;
            }
            case "oracle.jdbc.driver.OracleDriver": {
                return DatabaseType.Oracle;
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                return DatabaseType.SQLServer;
            }
            case "org.h2.Driver": {
                return DatabaseType.H2;
            }
        }
        throw new ShardingException("Cannot resolve JDBC url `%s`", new Object[]{url});
    }

    private JDBCDriverURLRecognizerEngine() {
    }

    static {
        JDBCDriverURLRecognizerEngine.load();
    }
}

