/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.shardingsphere.core.PreparedQueryShardingEngine;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.parse.SQLJudgeEngine;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.MasterSlaveSQLRewriteEngine;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;

public final class PreparedStatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final ShardingProxyContext SHARDING_PROXY_CONTEXT = ShardingProxyContext.getInstance();
    private final LogicSchema logicSchema;
    private final List<Object> parameters;

    @Override
    public SQLRouteResult route(String sql, DatabaseType databaseType) {
        return this.logicSchema instanceof MasterSlaveSchema ? this.doMasterSlaveRoute(sql) : this.doShardingRoute(sql, databaseType);
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        String rewriteSQL = new MasterSlaveSQLRewriteEngine(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), sql, sqlStatement, this.logicSchema.getMetaData()).rewrite();
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        for (String each : new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), ((Boolean)SHARDING_PROXY_CONTEXT.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(rewriteSQL)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, this.parameters)));
        }
        return result;
    }

    private SQLRouteResult doShardingRoute(String sql, DatabaseType databaseType) {
        PreparedQueryShardingEngine shardingEngine = new PreparedQueryShardingEngine(sql, ((ShardingSchema)this.logicSchema).getShardingRule(), ShardingProxyContext.getInstance().getShardingProperties(), this.logicSchema.getMetaData(), databaseType, this.logicSchema.getParsingResultCache());
        return shardingEngine.shard(sql, this.parameters);
    }

    @Override
    public Statement createStatement(Connection connection, SQLUnit sqlUnit, boolean isReturnGeneratedKeys) throws SQLException {
        PreparedStatement result = isReturnGeneratedKeys ? connection.prepareStatement(sqlUnit.getSql(), 1) : connection.prepareStatement(sqlUnit.getSql());
        for (int i = 0; i < sqlUnit.getParameters().size(); ++i) {
            result.setObject(i + 1, sqlUnit.getParameters().get(i));
        }
        return result;
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return ((PreparedStatement)statement).execute();
    }

    @ConstructorProperties(value={"logicSchema", "parameters"})
    public PreparedStatementExecutorWrapper(LogicSchema logicSchema, List<Object> parameters) {
        this.logicSchema = logicSchema;
        this.parameters = parameters;
    }
}

