/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import org.apache.shardingsphere.core.SimpleQueryShardingEngine;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.parse.SQLJudgeEngine;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.MasterSlaveSQLRewriteEngine;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;

public final class StatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final ShardingProxyContext SHARDING_PROXY_CONTEXT = ShardingProxyContext.getInstance();
    private final LogicSchema logicSchema;

    @Override
    public SQLRouteResult route(String sql, DatabaseType databaseType) {
        SQLRouteResult result = this.logicSchema instanceof ShardingSchema ? this.doShardingRoute(sql, databaseType) : (this.logicSchema instanceof MasterSlaveSchema ? this.doMasterSlaveRoute(sql) : this.doTransparentRoute(sql));
        return result;
    }

    private SQLRouteResult doTransparentRoute(String sql) {
        SQLRouteResult result = new SQLRouteResult(new SQLJudgeEngine(sql).judge());
        result.getRouteUnits().add(new RouteUnit(this.logicSchema.getDataSources().keySet().iterator().next(), new SQLUnit(sql, Collections.emptyList())));
        return result;
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        String rewriteSQL = new MasterSlaveSQLRewriteEngine(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), sql, sqlStatement, this.logicSchema.getMetaData()).rewrite();
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        for (String each : new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), ((Boolean)SHARDING_PROXY_CONTEXT.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(rewriteSQL)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, Collections.emptyList())));
        }
        return result;
    }

    private SQLRouteResult doShardingRoute(String sql, DatabaseType databaseType) {
        SimpleQueryShardingEngine shardingEngine = new SimpleQueryShardingEngine(((ShardingSchema)this.logicSchema).getShardingRule(), ShardingProxyContext.getInstance().getShardingProperties(), this.logicSchema.getMetaData(), databaseType, this.logicSchema.getParsingResultCache());
        return shardingEngine.shard(sql, Collections.emptyList());
    }

    @Override
    public Statement createStatement(Connection connection, SQLUnit sqlUnit, boolean isReturnGeneratedKeys) throws SQLException {
        return connection.createStatement();
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return statement.execute(sql, isReturnGeneratedKeys ? 1 : 2);
    }

    @ConstructorProperties(value={"logicSchema"})
    public StatementExecutorWrapper(LogicSchema logicSchema) {
        this.logicSchema = logicSchema;
    }
}

