/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.response.query;

import java.beans.ConstructorProperties;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;

public final class QueryHeader {
    private final String schema;
    private final String table;
    private final String columnLabel;
    private final String columnName;
    private final int columnLength;
    private final Integer columnType;
    private final int decimals;

    public QueryHeader(ResultSetMetaData resultSetMetaData, LogicSchema logicSchema, int columnIndex) throws SQLException {
        Collection tableNames;
        this.schema = logicSchema.getName();
        this.table = logicSchema instanceof ShardingSchema ? ((tableNames = ((ShardingSchema)logicSchema).getShardingRule().getLogicTableNames(resultSetMetaData.getTableName(columnIndex))).isEmpty() ? "" : (String)tableNames.iterator().next()) : resultSetMetaData.getTableName(columnIndex);
        this.columnLabel = resultSetMetaData.getColumnLabel(columnIndex);
        this.columnName = resultSetMetaData.getColumnName(columnIndex);
        this.columnLength = resultSetMetaData.getColumnDisplaySize(columnIndex);
        this.columnType = resultSetMetaData.getColumnType(columnIndex);
        this.decimals = resultSetMetaData.getScale(columnIndex);
    }

    @ConstructorProperties(value={"schema", "table", "columnLabel", "columnName", "columnLength", "columnType", "decimals"})
    public QueryHeader(String schema, String table, String columnLabel, String columnName, int columnLength, Integer columnType, int decimals) {
        this.schema = schema;
        this.table = table;
        this.columnLabel = columnLabel;
        this.columnName = columnName;
        this.columnLength = columnLength;
        this.columnType = columnType;
        this.decimals = decimals;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnLength() {
        return this.columnLength;
    }

    public Integer getColumnType() {
        return this.columnType;
    }

    public int getDecimals() {
        return this.decimals;
    }
}

