/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataConnectionManager;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataInitializer;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.cache.ParsingResultCache;
import org.apache.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCBackendDataSource;
import org.apache.shardingsphere.shardingproxy.backend.executor.BackendExecutorContext;
import org.apache.shardingsphere.shardingproxy.backend.schema.ProxyTableMetaDataConnectionManager;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.shardingproxy.util.DataSourceConverter;

public abstract class LogicSchema {
    private final String name;
    private final Map<String, YamlDataSourceParameter> dataSources;
    private final ParsingResultCache parsingResultCache;
    private JDBCBackendDataSource backendDataSource;

    public LogicSchema(String name, Map<String, YamlDataSourceParameter> dataSources) {
        this.name = name;
        this.dataSources = dataSources;
        this.parsingResultCache = new ParsingResultCache();
        this.backendDataSource = new JDBCBackendDataSource(dataSources);
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    public abstract ShardingMetaData getMetaData();

    protected final Map<String, String> getDataSourceURLs(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceParameters.size(), 1.0f);
        for (Map.Entry<String, YamlDataSourceParameter> entry : dataSourceParameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getUrl());
        }
        return result;
    }

    protected final TableMetaDataInitializer getTableMetaDataInitializer(ShardingDataSourceMetaData shardingDataSourceMetaData) {
        ShardingProperties shardingProperties = ShardingProxyContext.getInstance().getShardingProperties();
        return new TableMetaDataInitializer(shardingDataSourceMetaData, BackendExecutorContext.getInstance().getExecuteEngine(), (TableMetaDataConnectionManager)new ProxyTableMetaDataConnectionManager(this.getBackendDataSource()), ((Integer)shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), ((Boolean)shardingProperties.getValue(ShardingPropertiesConstant.CHECK_TABLE_METADATA_ENABLED)).booleanValue());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) throws Exception {
        if (!this.name.equals(dataSourceChangedEvent.getShardingSchemaName())) {
            return;
        }
        this.backendDataSource.close();
        this.dataSources.clear();
        this.dataSources.putAll(DataSourceConverter.getDataSourceParameterMap((Map)dataSourceChangedEvent.getDataSourceConfigurations()));
        this.backendDataSource = new JDBCBackendDataSource(this.dataSources);
    }

    public void refreshTableMetaData(SQLStatement sqlStatement) {
    }

    public String getName() {
        return this.name;
    }

    public Map<String, YamlDataSourceParameter> getDataSources() {
        return this.dataSources;
    }

    public ParsingResultCache getParsingResultCache() {
        return this.parsingResultCache;
    }

    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }
}

