/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.ShardingRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class ShardingSchema
extends LogicSchema {
    private ShardingRule shardingRule;
    private final ShardingMetaData metaData;

    public ShardingSchema(String name, Map<String, YamlDataSourceParameter> dataSources, ShardingRuleConfiguration shardingRuleConfig, boolean isUsingRegistry) {
        super(name, dataSources);
        this.shardingRule = this.createShardingRule(shardingRuleConfig, dataSources.keySet(), isUsingRegistry);
        this.metaData = this.createShardingMetaData();
    }

    private ShardingRule createShardingRule(ShardingRuleConfiguration shardingRuleConfig, Collection<String> dataSourceNames, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationShardingRule(shardingRuleConfig, dataSourceNames) : new ShardingRule(shardingRuleConfig, dataSourceNames);
    }

    private ShardingMetaData createShardingMetaData() {
        ShardingDataSourceMetaData shardingDataSourceMetaData = new ShardingDataSourceMetaData(this.getDataSourceURLs(this.getDataSources()), this.shardingRule, LogicSchemas.getInstance().getDatabaseType());
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(this.getTableMetaDataInitializer(shardingDataSourceMetaData).load(this.shardingRule));
        return new ShardingMetaData(shardingDataSourceMetaData, shardingTableMetaData);
    }

    @Subscribe
    public synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        if (this.getName().equals(shardingRuleChangedEvent.getShardingSchemaName())) {
            this.shardingRule = new OrchestrationShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.getDataSources().keySet());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : this.shardingRule.getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }

    @Override
    public void refreshTableMetaData(SQLStatement sqlStatement) {
        if (sqlStatement instanceof CreateTableStatement) {
            this.refreshTableMetaData((CreateTableStatement)sqlStatement);
        } else if (sqlStatement instanceof AlterTableStatement) {
            this.refreshTableMetaData((AlterTableStatement)sqlStatement);
        } else if (sqlStatement instanceof DropTableStatement) {
            this.refreshTableMetaData((DropTableStatement)sqlStatement);
        }
    }

    private void refreshTableMetaData(CreateTableStatement createTableStatement) {
        String tableName = createTableStatement.getTables().getSingleTableName();
        this.getMetaData().getTable().put(tableName, this.getTableMetaDataInitializer(this.metaData.getDataSource()).load(tableName, this.shardingRule));
    }

    private void refreshTableMetaData(AlterTableStatement alterTableStatement) {
        String tableName = alterTableStatement.getTables().getSingleTableName();
        this.getMetaData().getTable().put(tableName, this.getTableMetaDataInitializer(this.metaData.getDataSource()).load(tableName, this.shardingRule));
    }

    private void refreshTableMetaData(DropTableStatement dropTableStatement) {
        for (String each : dropTableStatement.getTables().getTableNames()) {
            this.getMetaData().getTable().remove(each);
        }
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

