/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.List;
import org.apache.shardingsphere.core.constant.SQLType;
import org.apache.shardingsphere.core.parse.SQLJudgeEngine;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.ShowDatabasesStatement;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.UseStatement;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.BroadcastBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.ShowDatabasesBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.UnicastBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.admin.UseDatabaseBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.query.QueryBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.ShardingCTLBackendHandlerFactory;
import org.apache.shardingsphere.shardingproxy.backend.text.transaction.SkipBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.transaction.TransactionBackendHandler;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TextProtocolBackendHandlerFactory {
    private static final String SET_AUTOCOMMIT_1 = "SET AUTOCOMMIT=1";
    private static final List<String> GUI_SQL = Arrays.asList("SET", "SHOW VARIABLES LIKE", "SHOW CHARACTER SET", "SHOW COLLATION");

    public static TextProtocolBackendHandler newInstance(String sql, BackendConnection backendConnection) {
        if (sql.toUpperCase().startsWith("SCTL:")) {
            return ShardingCTLBackendHandlerFactory.newInstance(sql, backendConnection);
        }
        Optional transactionOperationType = TransactionOperationType.getOperationType((String)sql.toUpperCase());
        if (transactionOperationType.isPresent()) {
            return new TransactionBackendHandler((TransactionOperationType)transactionOperationType.get(), backendConnection);
        }
        if (sql.toUpperCase().contains(SET_AUTOCOMMIT_1)) {
            return backendConnection.getStateHandler().isInTransaction() ? new TransactionBackendHandler(TransactionOperationType.COMMIT, backendConnection) : new SkipBackendHandler();
        }
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        return SQLType.DAL == sqlStatement.getType() ? TextProtocolBackendHandlerFactory.createDALBackendHandler(sqlStatement, sql, backendConnection) : new QueryBackendHandler(sql, backendConnection);
    }

    private static TextProtocolBackendHandler createDALBackendHandler(SQLStatement sqlStatement, String sql, BackendConnection backendConnection) {
        for (String each : GUI_SQL) {
            if (!sql.toUpperCase().startsWith(each)) continue;
            return new BroadcastBackendHandler(sql, backendConnection);
        }
        if (sqlStatement instanceof UseStatement) {
            return new UseDatabaseBackendHandler((UseStatement)sqlStatement, backendConnection);
        }
        if (sqlStatement instanceof ShowDatabasesStatement) {
            return new ShowDatabasesBackendHandler();
        }
        return new UnicastBackendHandler(sql, backendConnection);
    }

    private TextProtocolBackendHandlerFactory() {
    }
}

