/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.admin;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.old.parser.dialect.mysql.statement.UseStatement;
import org.apache.shardingsphere.core.parse.util.SQLUtil;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;

public final class UseDatabaseBackendHandler
implements TextProtocolBackendHandler {
    private final UseStatement useStatement;
    private final BackendConnection backendConnection;

    @Override
    public BackendResponse execute() {
        String schema = SQLUtil.getExactlyValue((String)this.useStatement.getSchema());
        if (!LogicSchemas.getInstance().schemaExists(schema)) {
            return new ErrorResponse(new UnknownDatabaseException(schema));
        }
        this.backendConnection.setCurrentSchema(schema);
        return new UpdateResponse();
    }

    @Override
    public boolean next() {
        return false;
    }

    @Override
    public QueryData getQueryData() {
        return null;
    }

    @ConstructorProperties(value={"useStatement", "backendConnection"})
    public UseDatabaseBackendHandler(UseStatement useStatement, BackendConnection backendConnection) {
        this.useStatement = useStatement;
        this.backendConnection = backendConnection;
    }
}

