/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl;

import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.explain.ShardingCTLExplainBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.set.ShardingCTLSetBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.show.ShardingCTLShowBackendHandler;

public final class ShardingCTLBackendHandlerFactory {
    public static final String SCTL = "SCTL:";
    private static final String SCTL_SET = "SCTL:SET";
    private static final String SCTL_SHOW = "SCTL:SHOW";
    private static final String SCTL_EXPLAIN = "SCTL:EXPLAIN";

    public static TextProtocolBackendHandler newInstance(String sql, BackendConnection backendConnection) {
        if (sql.toUpperCase().startsWith(SCTL_SET)) {
            return new ShardingCTLSetBackendHandler(sql, backendConnection);
        }
        if (sql.toUpperCase().startsWith(SCTL_SHOW)) {
            return new ShardingCTLShowBackendHandler(sql, backendConnection);
        }
        if (sql.toUpperCase().startsWith(SCTL_EXPLAIN)) {
            return new ShardingCTLExplainBackendHandler(sql, backendConnection);
        }
        throw new IllegalArgumentException(sql);
    }
}

