/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.recognizer.spi.JDBCDriverURLRecognizer;

public final class JDBCDriverURLRecognizerEngine {
    private static final Collection<JDBCDriverURLRecognizer> JDBC_DRIVER_URL_RECOGNIZERS = new LinkedList<JDBCDriverURLRecognizer>();

    public static JDBCDriverURLRecognizer getJDBCDriverURLRecognizer(String url) {
        for (JDBCDriverURLRecognizer each : JDBC_DRIVER_URL_RECOGNIZERS) {
            if (!JDBCDriverURLRecognizerEngine.isMatchURL(url, each)) continue;
            return each;
        }
        throw new ShardingException("Cannot resolve JDBC url `%s`. Please implements `%s` and add to SPI.", new Object[]{url, JDBCDriverURLRecognizer.class.getName()});
    }

    private static boolean isMatchURL(String url, JDBCDriverURLRecognizer jdbcDriverURLRecognizer) {
        for (String each : jdbcDriverURLRecognizer.getURLPrefixes()) {
            if (!url.startsWith(each)) continue;
            return true;
        }
        return false;
    }

    private JDBCDriverURLRecognizerEngine() {
    }

    static {
        for (JDBCDriverURLRecognizer each : ServiceLoader.load(JDBCDriverURLRecognizer.class)) {
            JDBC_DRIVER_URL_RECOGNIZERS.add(each);
        }
    }
}

