/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.apache.shardingsphere.api.config.encrypt.EncryptRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.util.ConfigurationLogger;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.EncryptRuleChangedEvent;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class EncryptSchema
extends LogicSchema {
    private final ShardingMetaData metaData;
    private final ShardingRule shardingRule;
    private EncryptRule encryptRule;

    public EncryptSchema(String name, Map<String, YamlDataSourceParameter> dataSources, EncryptRuleConfiguration encryptRuleConfiguration) {
        super(name, dataSources);
        this.encryptRule = new EncryptRule(encryptRuleConfiguration);
        this.shardingRule = new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet());
        this.metaData = this.createShardingMetaData();
    }

    private ShardingMetaData createShardingMetaData() {
        ShardingDataSourceMetaData shardingDataSourceMetaData = new ShardingDataSourceMetaData(this.getDataSourceURLs(this.getDataSources()), this.shardingRule, LogicSchemas.getInstance().getDatabaseType());
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(this.getTableMetaDataInitializer(shardingDataSourceMetaData).load(this.shardingRule));
        return new ShardingMetaData(shardingDataSourceMetaData, shardingTableMetaData);
    }

    @Subscribe
    public synchronized void renew(EncryptRuleChangedEvent encryptRuleChangedEvent) {
        ConfigurationLogger.log((EncryptRuleConfiguration)encryptRuleChangedEvent.getEncryptRuleConfiguration());
        this.encryptRule = new EncryptRule(encryptRuleChangedEvent.getEncryptRuleConfiguration());
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    public EncryptRule getEncryptRule() {
        return this.encryptRule;
    }
}

