/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.base.Optional;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.optimize.api.statement.OptimizedStatement;
import org.apache.shardingsphere.core.parse.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.util.ConfigurationLogger;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.ShardingRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class ShardingSchema
extends LogicSchema {
    private ShardingRule shardingRule;
    private final ShardingMetaData metaData;

    public ShardingSchema(String name, Map<String, YamlDataSourceParameter> dataSources, ShardingRuleConfiguration shardingRuleConfig, boolean isUsingRegistry) {
        super(name, dataSources);
        this.shardingRule = this.createShardingRule(shardingRuleConfig, dataSources.keySet(), isUsingRegistry);
        this.metaData = this.createShardingMetaData();
    }

    private ShardingRule createShardingRule(ShardingRuleConfiguration shardingRuleConfig, Collection<String> dataSourceNames, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationShardingRule(shardingRuleConfig, dataSourceNames) : new ShardingRule(shardingRuleConfig, dataSourceNames);
    }

    private ShardingMetaData createShardingMetaData() {
        ShardingDataSourceMetaData shardingDataSourceMetaData = new ShardingDataSourceMetaData(this.getDataSourceURLs(this.getDataSources()), this.shardingRule, LogicSchemas.getInstance().getDatabaseType());
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(this.getTableMetaDataInitializer(shardingDataSourceMetaData).load(this.shardingRule));
        return new ShardingMetaData(shardingDataSourceMetaData, shardingTableMetaData);
    }

    @Subscribe
    public synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        if (this.getName().equals(shardingRuleChangedEvent.getShardingSchemaName())) {
            ConfigurationLogger.log((ShardingRuleConfiguration)shardingRuleChangedEvent.getShardingRuleConfiguration());
            this.shardingRule = new OrchestrationShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.getDataSources().keySet());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : this.shardingRule.getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }

    @Override
    public void refreshTableMetaData(OptimizedStatement optimizedStatement) {
        if (null == optimizedStatement) {
            return;
        }
        if (optimizedStatement.getSQLStatement() instanceof CreateTableStatement) {
            this.refreshTableMetaDataForCreateTable(optimizedStatement);
        } else if (optimizedStatement.getSQLStatement() instanceof AlterTableStatement) {
            this.refreshTableMetaDataForAlterTable(optimizedStatement);
        } else if (optimizedStatement.getSQLStatement() instanceof DropTableStatement) {
            this.refreshTableMetaDataForDropTable(optimizedStatement);
        } else if (optimizedStatement.getSQLStatement() instanceof CreateIndexStatement) {
            this.refreshTableMetaDataForCreateIndex(optimizedStatement);
        } else if (optimizedStatement.getSQLStatement() instanceof DropIndexStatement) {
            this.refreshTableMetaDataForDropIndex(optimizedStatement);
        }
    }

    private void refreshTableMetaDataForCreateTable(OptimizedStatement optimizedStatement) {
        String tableName = optimizedStatement.getTables().getSingleTableName();
        this.getMetaData().getTable().put(tableName, this.getTableMetaDataInitializer(this.metaData.getDataSource()).load(tableName, this.shardingRule));
    }

    private void refreshTableMetaDataForAlterTable(OptimizedStatement optimizedStatement) {
        String tableName = optimizedStatement.getTables().getSingleTableName();
        this.getMetaData().getTable().put(tableName, this.getTableMetaDataInitializer(this.metaData.getDataSource()).load(tableName, this.shardingRule));
    }

    private void refreshTableMetaDataForDropTable(OptimizedStatement optimizedStatement) {
        for (String each : optimizedStatement.getTables().getTableNames()) {
            this.getMetaData().getTable().remove(each);
        }
    }

    private void refreshTableMetaDataForCreateIndex(OptimizedStatement optimizedStatement) {
        CreateIndexStatement createIndexStatement = (CreateIndexStatement)optimizedStatement.getSQLStatement();
        if (null == createIndexStatement.getIndex()) {
            return;
        }
        this.getMetaData().getTable().get(optimizedStatement.getTables().getSingleTableName()).getLogicIndexes().add(createIndexStatement.getIndex().getName());
    }

    private void refreshTableMetaDataForDropIndex(OptimizedStatement optimizedStatement) {
        DropIndexStatement dropIndexStatement = (DropIndexStatement)optimizedStatement.getSQLStatement();
        Collection<String> indexNames = this.getIndexNames(dropIndexStatement);
        if (!optimizedStatement.getTables().isEmpty()) {
            this.getMetaData().getTable().get(optimizedStatement.getTables().getSingleTableName()).getLogicIndexes().removeAll(indexNames);
        }
        for (String each : indexNames) {
            Optional logicTableName = this.getMetaData().getTable().getLogicTableName(each);
            if (!logicTableName.isPresent()) continue;
            this.getMetaData().getTable().get((String)logicTableName.get()).getLogicIndexes().remove(each);
        }
    }

    private Collection<String> getIndexNames(DropIndexStatement dropIndexStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IndexSegment each : dropIndexStatement.getIndexes()) {
            result.add(each.getName());
        }
        return result;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

