/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.transaction;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendTransactionManager;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TransactionBackendHandler
implements TextProtocolBackendHandler {
    private final TransactionOperationType operationType;
    private final BackendTransactionManager backendTransactionManager;

    public TransactionBackendHandler(TransactionOperationType operationType, BackendConnection backendConnection) {
        this.operationType = operationType;
        this.backendTransactionManager = new BackendTransactionManager(backendConnection);
    }

    @Override
    public BackendResponse execute() {
        try {
            return this.doTransaction();
        }
        catch (SQLException ex) {
            return new ErrorResponse(ex);
        }
    }

    private BackendResponse doTransaction() throws SQLException {
        switch (this.operationType) {
            case BEGIN: {
                this.backendTransactionManager.begin();
                break;
            }
            case COMMIT: {
                this.backendTransactionManager.commit();
                break;
            }
            case ROLLBACK: {
                this.backendTransactionManager.rollback();
                break;
            }
            default: {
                throw new SQLFeatureNotSupportedException(this.operationType.name());
            }
        }
        return new UpdateResponse();
    }

    @Override
    public boolean next() {
        return false;
    }

    @Override
    public QueryData getQueryData() {
        return null;
    }
}

