/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection;

import java.beans.ConstructorProperties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.ConnectionStatus;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.ResourceSynchronizer;

public class ConnectionStateHandler {
    private final AtomicReference<ConnectionStatus> status = new AtomicReference<ConnectionStatus>(ConnectionStatus.INIT);
    private final ResourceSynchronizer resourceSynchronizer;

    public void setStatus(ConnectionStatus update) {
        this.status.getAndSet(update);
        if (ConnectionStatus.TERMINATED == this.status.get()) {
            this.resourceSynchronizer.doNotify();
        }
    }

    public ConnectionStatus getStatus() {
        return this.status.get();
    }

    public void setRunningStatusIfNecessary() {
        if (ConnectionStatus.TRANSACTION != this.status.get() && ConnectionStatus.RUNNING != this.status.get()) {
            this.status.getAndSet(ConnectionStatus.RUNNING);
        }
    }

    public boolean isInTransaction() {
        return ConnectionStatus.TRANSACTION == this.status.get();
    }

    void doNotifyIfNecessary() {
        if (this.status.compareAndSet(ConnectionStatus.RUNNING, ConnectionStatus.RELEASE) || this.status.compareAndSet(ConnectionStatus.TERMINATED, ConnectionStatus.RELEASE)) {
            this.resourceSynchronizer.doNotify();
        }
    }

    public void waitUntilConnectionReleasedIfNecessary() throws InterruptedException {
        if (ConnectionStatus.RUNNING == this.status.get() || ConnectionStatus.TERMINATED == this.status.get()) {
            while (!this.status.compareAndSet(ConnectionStatus.RELEASE, ConnectionStatus.RUNNING)) {
                this.resourceSynchronizer.doAwaitUntil();
            }
        }
    }

    @ConstructorProperties(value={"resourceSynchronizer"})
    public ConnectionStateHandler(ResourceSynchronizer resourceSynchronizer) {
        this.resourceSynchronizer = resourceSynchronizer;
    }
}

