/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.MethodInvocation;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.TransactionManager;

public final class LocalTransactionManager
implements TransactionManager {
    private final BackendConnection connection;

    @Override
    public void begin() {
        this.recordMethodInvocation(Connection.class, "setAutoCommit", new Class[]{Boolean.TYPE}, new Object[]{false});
    }

    @Override
    public void commit() throws SQLException {
        if (this.connection.getStateHandler().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
            exceptions.addAll(this.commitConnections());
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.connection.getStateHandler().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
            exceptions.addAll(this.rollbackConnections());
            this.throwSQLExceptionIfNecessary(exceptions);
        }
    }

    private Collection<SQLException> commitConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private Collection<SQLException> rollbackConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        throw ex;
    }

    private void recordMethodInvocation(Class<?> targetClass, String methodName, Class<?>[] argumentTypes, Object[] arguments) {
        this.connection.getMethodInvocations().add(new MethodInvocation(targetClass.getMethod(methodName, argumentTypes), arguments));
    }

    @ConstructorProperties(value={"connection"})
    public LocalTransactionManager(BackendConnection connection) {
        this.connection = connection;
    }
}

