/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.exception.ShardingException;
import org.apache.shardingsphere.shardingproxy.backend.BackendDataSource;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCBackendDataSourceFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.datasource.JDBCRawBackendDataSourceFactory;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;
import org.apache.shardingsphere.transaction.ShardingTransactionManagerEngine;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingTransactionManager;

public final class JDBCBackendDataSource
implements BackendDataSource,
AutoCloseable {
    private Map<String, DataSource> dataSources;
    private final Map<String, YamlDataSourceParameter> dataSourceParameters;
    private final JDBCBackendDataSourceFactory dataSourceFactory = JDBCRawBackendDataSourceFactory.getInstance();
    private ShardingTransactionManagerEngine shardingTransactionManagerEngine = new ShardingTransactionManagerEngine();

    public JDBCBackendDataSource(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        this.dataSourceParameters = dataSourceParameters;
        this.dataSources = this.createDataSources(dataSourceParameters);
        this.shardingTransactionManagerEngine.init(LogicSchemas.getInstance().getDatabaseType(), this.dataSources);
    }

    private Map<String, DataSource> createDataSources(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(dataSourceParameters.size(), 1.0f);
        for (Map.Entry<String, YamlDataSourceParameter> entry : dataSourceParameters.entrySet()) {
            try {
                result.put(entry.getKey(), this.dataSourceFactory.build(entry.getKey(), entry.getValue()));
            }
            catch (Exception ex) {
                throw new ShardingException(String.format("Can not build data source, name is `%s`.", entry.getKey()), ex);
            }
        }
        return result;
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        return this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0);
    }

    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        return this.getConnections(connectionMode, dataSourceName, connectionSize, TransactionType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize, TransactionType transactionType) throws SQLException {
        DataSource dataSource = this.dataSources.get(dataSourceName);
        if (1 == connectionSize) {
            return Collections.singletonList(this.createConnection(transactionType, dataSourceName, dataSource));
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(transactionType, dataSourceName, dataSource, connectionSize);
        }
        DataSource dataSource2 = dataSource;
        synchronized (dataSource2) {
            return this.createConnections(transactionType, dataSourceName, dataSource, connectionSize);
        }
    }

    private List<Connection> createConnections(TransactionType transactionType, String dataSourceName, DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                result.add(this.createConnection(transactionType, dataSourceName, dataSource));
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Could't get %d connections one time, partition succeed connection(%d) have released!", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    private Connection createConnection(TransactionType transactionType, String dataSourceName, DataSource dataSource) throws SQLException {
        ShardingTransactionManager shardingTransactionManager = this.shardingTransactionManagerEngine.getTransactionManager(transactionType);
        return this.isInShardingTransaction(shardingTransactionManager) ? shardingTransactionManager.getConnection(dataSourceName) : dataSource.getConnection();
    }

    private boolean isInShardingTransaction(ShardingTransactionManager shardingTransactionManager) {
        return null != shardingTransactionManager && shardingTransactionManager.isInTransaction();
    }

    @Override
    public void close() throws Exception {
        if (null == this.dataSources) {
            return;
        }
        this.dataSourceParameters.clear();
        this.close(this.dataSources.keySet());
        this.shardingTransactionManagerEngine.close();
    }

    private void close(Collection<String> dataSourceNames) {
        for (String each : dataSourceNames) {
            this.close(this.dataSources.get(each));
        }
    }

    private void close(DataSource dataSource) {
        try {
            Method method = dataSource.getClass().getDeclaredMethod("close", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)dataSource, new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }

    public void renew(Map<String, YamlDataSourceParameter> dataSourceParameters) throws Exception {
        List<String> deletedDataSources = this.getDeletedDataSources(dataSourceParameters);
        Map<String, YamlDataSourceParameter> modifiedDataSources = this.getModifiedDataSources(dataSourceParameters);
        this.close(deletedDataSources);
        this.close(modifiedDataSources.keySet());
        this.dataSources = this.getChangedDataSources(deletedDataSources, this.getAddedDataSources(dataSourceParameters), modifiedDataSources);
        this.dataSourceParameters.clear();
        this.dataSourceParameters.putAll(dataSourceParameters);
        this.shardingTransactionManagerEngine.close();
        this.shardingTransactionManagerEngine.init(LogicSchemas.getInstance().getDatabaseType(), this.dataSources);
    }

    private synchronized List<String> getDeletedDataSources(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        LinkedList<String> result = new LinkedList<String>(this.dataSourceParameters.keySet());
        result.removeAll(dataSourceParameters.keySet());
        return result;
    }

    private synchronized Map<String, YamlDataSourceParameter> getModifiedDataSources(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, YamlDataSourceParameter> result = new LinkedHashMap<String, YamlDataSourceParameter>();
        for (Map.Entry<String, YamlDataSourceParameter> entry : dataSourceParameters.entrySet()) {
            if (!this.isModifiedDataSource(entry)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private synchronized boolean isModifiedDataSource(Map.Entry<String, YamlDataSourceParameter> dataSourceNameAndParameters) {
        return this.dataSourceParameters.containsKey(dataSourceNameAndParameters.getKey()) && !this.dataSourceParameters.get(dataSourceNameAndParameters.getKey()).equals((Object)dataSourceNameAndParameters.getValue());
    }

    private synchronized Map<String, DataSource> getChangedDataSources(List<String> deletedDataSources, Map<String, YamlDataSourceParameter> addedDataSources, Map<String, YamlDataSourceParameter> modifiedDataSources) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(this.dataSources);
        result.keySet().removeAll(deletedDataSources);
        result.keySet().removeAll(modifiedDataSources.keySet());
        result.putAll(this.createDataSources(modifiedDataSources));
        result.putAll(this.createDataSources(this.getAddedDataSources(addedDataSources)));
        return result;
    }

    private synchronized Map<String, YamlDataSourceParameter> getAddedDataSources(Map<String, YamlDataSourceParameter> dataSourceParameters) {
        return Maps.filterEntries(dataSourceParameters, (Predicate)new Predicate<Map.Entry<String, YamlDataSourceParameter>>(){

            public boolean apply(Map.Entry<String, YamlDataSourceParameter> input) {
                return !JDBCBackendDataSource.this.getDataSourceParameters().containsKey(input.getKey());
            }
        });
    }

    public Map<String, YamlDataSourceParameter> getDataSourceParameters() {
        return this.dataSourceParameters;
    }

    public ShardingTransactionManagerEngine getShardingTransactionManagerEngine() {
        return this.shardingTransactionManagerEngine;
    }
}

