/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.callback;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.execute.StatementExecuteUnit;
import org.apache.shardingsphere.core.execute.sql.prepare.SQLExecutePrepareCallback;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.spi.database.MySQLDatabaseType;
import org.apache.shardingsphere.core.spi.database.PostgreSQLDatabaseType;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;

public final class ProxyJDBCExecutePrepareCallback
implements SQLExecutePrepareCallback {
    private static final Integer MYSQL_MEMORY_FETCH_ONE_ROW_A_TIME = Integer.MIN_VALUE;
    private static final int POSTGRESQL_MEMORY_FETCH_ONE_ROW_A_TIME = 1;
    private final BackendConnection backendConnection;
    private final JDBCExecutorWrapper jdbcExecutorWrapper;
    private final boolean isReturnGeneratedKeys;

    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        return this.backendConnection.getConnections(connectionMode, dataSourceName, connectionSize);
    }

    public StatementExecuteUnit createStatementExecuteUnit(Connection connection, RouteUnit routeUnit, ConnectionMode connectionMode) throws SQLException {
        Statement statement = this.jdbcExecutorWrapper.createStatement(connection, routeUnit.getSqlUnit(), this.isReturnGeneratedKeys);
        if (connectionMode.equals((Object)ConnectionMode.MEMORY_STRICTLY)) {
            if (LogicSchemas.getInstance().getDatabaseType() instanceof MySQLDatabaseType) {
                statement.setFetchSize(MYSQL_MEMORY_FETCH_ONE_ROW_A_TIME);
            } else if (LogicSchemas.getInstance().getDatabaseType() instanceof PostgreSQLDatabaseType) {
                statement.setFetchSize(1);
            }
        }
        return new StatementExecuteUnit(routeUnit, statement, connectionMode);
    }

    @ConstructorProperties(value={"backendConnection", "jdbcExecutorWrapper", "isReturnGeneratedKeys"})
    public ProxyJDBCExecutePrepareCallback(BackendConnection backendConnection, JDBCExecutorWrapper jdbcExecutorWrapper, boolean isReturnGeneratedKeys) {
        this.backendConnection = backendConnection;
        this.jdbcExecutorWrapper = jdbcExecutorWrapper;
        this.isReturnGeneratedKeys = isReturnGeneratedKeys;
    }
}

