/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.callback;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteCallback;
import org.apache.shardingsphere.core.execute.sql.execute.result.MemoryQueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.StreamQueryResult;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteQueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.execute.response.ExecuteUpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.impl.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;

public final class ProxySQLExecuteCallback
extends SQLExecuteCallback<ExecuteResponse> {
    private final BackendConnection backendConnection;
    private final JDBCExecutorWrapper jdbcExecutorWrapper;
    private final SQLStatementContext sqlStatementContext;
    private final boolean isReturnGeneratedKeys;
    private final boolean fetchMetaData;
    private boolean hasMetaData;

    public ProxySQLExecuteCallback(BackendConnection backendConnection, JDBCExecutorWrapper jdbcExecutorWrapper, SQLStatementContext sqlStatementContext, boolean isExceptionThrown, boolean isReturnGeneratedKeys, boolean fetchMetaData) {
        super(LogicSchemas.getInstance().getDatabaseType(), isExceptionThrown);
        this.backendConnection = backendConnection;
        this.jdbcExecutorWrapper = jdbcExecutorWrapper;
        this.sqlStatementContext = sqlStatementContext;
        this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        this.fetchMetaData = fetchMetaData;
    }

    public ExecuteResponse executeSQL(RouteUnit routeUnit, Statement statement, ConnectionMode connectionMode) throws SQLException {
        boolean withMetaData = false;
        if (this.fetchMetaData && !this.hasMetaData) {
            this.hasMetaData = true;
            withMetaData = true;
        }
        return this.executeSQL(statement, routeUnit.getSqlUnit().getSql(), connectionMode, withMetaData);
    }

    private ExecuteResponse executeSQL(Statement statement, String sql, ConnectionMode connectionMode, boolean withMetadata) throws SQLException {
        this.backendConnection.add(statement);
        if (this.jdbcExecutorWrapper.executeSQL(statement, sql, this.isReturnGeneratedKeys)) {
            ResultSet resultSet = statement.getResultSet();
            this.backendConnection.add(resultSet);
            return new ExecuteQueryResponse(withMetadata ? this.getQueryHeaders(resultSet.getMetaData()) : null, this.createQueryResult(resultSet, connectionMode));
        }
        return new ExecuteUpdateResponse(statement.getUpdateCount(), this.isReturnGeneratedKeys ? this.getGeneratedKey(statement) : 0L);
    }

    private List<QueryHeader> getQueryHeaders(ResultSetMetaData resultSetMetaData) throws SQLException {
        LinkedList<QueryHeader> result = new LinkedList<QueryHeader>();
        for (int columnIndex = 1; columnIndex <= resultSetMetaData.getColumnCount(); ++columnIndex) {
            result.add(new QueryHeader(resultSetMetaData, this.backendConnection.getLogicSchema(), columnIndex));
        }
        return result;
    }

    private QueryResult createQueryResult(ResultSet resultSet, ConnectionMode connectionMode) throws SQLException {
        LogicSchema logicSchema = this.backendConnection.getLogicSchema();
        if (logicSchema instanceof ShardingSchema) {
            ShardingRule shardingRule = logicSchema.getShardingRule();
            ShardingProperties properties = ShardingProxyContext.getInstance().getShardingProperties();
            return connectionMode == ConnectionMode.MEMORY_STRICTLY ? new StreamQueryResult(resultSet, shardingRule, properties, this.sqlStatementContext) : new MemoryQueryResult(resultSet, shardingRule, properties, this.sqlStatementContext);
        }
        if (logicSchema instanceof EncryptSchema) {
            EncryptRule encryptRule = ((EncryptSchema)logicSchema).getEncryptRule();
            ShardingProperties properties = ShardingProxyContext.getInstance().getShardingProperties();
            return connectionMode == ConnectionMode.MEMORY_STRICTLY ? new StreamQueryResult(resultSet, encryptRule, properties, this.sqlStatementContext) : new MemoryQueryResult(resultSet, encryptRule, properties, this.sqlStatementContext);
        }
        return connectionMode == ConnectionMode.MEMORY_STRICTLY ? new StreamQueryResult(resultSet) : new MemoryQueryResult(resultSet);
    }

    private long getGeneratedKey(Statement statement) throws SQLException {
        ResultSet resultSet = statement.getGeneratedKeys();
        return resultSet.next() ? resultSet.getLong(1) : 0L;
    }
}

