/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema.impl;

import com.google.common.base.Optional;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.core.metadata.datasource.DataSourceMetas;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.sql.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.core.parse.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.util.ConfigurationLogger;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.ShardingRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationShardingRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class ShardingSchema
extends LogicSchema {
    private ShardingRule shardingRule;
    private final ShardingSphereMetaData metaData;

    public ShardingSchema(String name, Map<String, YamlDataSourceParameter> dataSources, ShardingRuleConfiguration shardingRuleConfig, boolean isUsingRegistry) throws SQLException {
        super(name, dataSources);
        this.shardingRule = this.createShardingRule(shardingRuleConfig, dataSources.keySet(), isUsingRegistry);
        this.metaData = this.createMetaData();
    }

    private ShardingRule createShardingRule(ShardingRuleConfiguration shardingRuleConfig, Collection<String> dataSourceNames, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationShardingRule(shardingRuleConfig, dataSourceNames) : new ShardingRule(shardingRuleConfig, dataSourceNames);
    }

    private ShardingSphereMetaData createMetaData() throws SQLException {
        DataSourceMetas dataSourceMetas = new DataSourceMetas(this.getDataSourceURLs(this.getDataSources()), LogicSchemas.getInstance().getDatabaseType());
        TableMetas tableMetas = new TableMetas(this.getTableMetaDataInitializer(dataSourceMetas).load(this.shardingRule));
        return new ShardingSphereMetaData(dataSourceMetas, tableMetas);
    }

    @Subscribe
    public synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        if (this.getName().equals(shardingRuleChangedEvent.getShardingSchemaName())) {
            ConfigurationLogger.log((ShardingRuleConfiguration)shardingRuleChangedEvent.getShardingRuleConfiguration());
            this.shardingRule = new OrchestrationShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.getDataSources().keySet());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : this.shardingRule.getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }

    @Override
    public void refreshTableMetaData(SQLStatementContext sqlStatementContext) throws SQLException {
        if (null == sqlStatementContext) {
            return;
        }
        if (sqlStatementContext.getSqlStatement() instanceof CreateTableStatement) {
            this.refreshTableMetaDataForCreateTable(sqlStatementContext);
        } else if (sqlStatementContext.getSqlStatement() instanceof AlterTableStatement) {
            this.refreshTableMetaDataForAlterTable(sqlStatementContext);
        } else if (sqlStatementContext.getSqlStatement() instanceof DropTableStatement) {
            this.refreshTableMetaDataForDropTable(sqlStatementContext);
        } else if (sqlStatementContext.getSqlStatement() instanceof CreateIndexStatement) {
            this.refreshTableMetaDataForCreateIndex(sqlStatementContext);
        } else if (sqlStatementContext.getSqlStatement() instanceof DropIndexStatement) {
            this.refreshTableMetaDataForDropIndex(sqlStatementContext);
        }
    }

    private void refreshTableMetaDataForCreateTable(SQLStatementContext sqlStatementContext) throws SQLException {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        this.getMetaData().getTables().put(tableName, this.getTableMetaDataInitializer(this.metaData.getDataSources()).load(tableName, this.shardingRule));
    }

    private void refreshTableMetaDataForAlterTable(SQLStatementContext sqlStatementContext) throws SQLException {
        String tableName = sqlStatementContext.getTablesContext().getSingleTableName();
        this.getMetaData().getTables().put(tableName, this.getTableMetaDataInitializer(this.metaData.getDataSources()).load(tableName, this.shardingRule));
    }

    private void refreshTableMetaDataForDropTable(SQLStatementContext sqlStatementContext) {
        for (String each : sqlStatementContext.getTablesContext().getTableNames()) {
            this.getMetaData().getTables().remove(each);
        }
    }

    private void refreshTableMetaDataForCreateIndex(SQLStatementContext sqlStatementContext) {
        CreateIndexStatement createIndexStatement = (CreateIndexStatement)sqlStatementContext.getSqlStatement();
        if (null != createIndexStatement.getIndex()) {
            this.getMetaData().getTables().get(sqlStatementContext.getTablesContext().getSingleTableName()).getIndexes().add(createIndexStatement.getIndex().getName());
        }
    }

    private void refreshTableMetaDataForDropIndex(SQLStatementContext sqlStatementContext) {
        DropIndexStatement dropIndexStatement = (DropIndexStatement)sqlStatementContext.getSqlStatement();
        Collection<String> indexNames = this.getIndexNames(dropIndexStatement);
        if (!sqlStatementContext.getTablesContext().isEmpty()) {
            this.getMetaData().getTables().get(sqlStatementContext.getTablesContext().getSingleTableName()).getIndexes().removeAll(indexNames);
        }
        for (String each : indexNames) {
            Optional<String> logicTableName = this.findLogicTableName(this.getMetaData().getTables(), each);
            if (!logicTableName.isPresent()) continue;
            this.getMetaData().getTables().get(sqlStatementContext.getTablesContext().getSingleTableName()).getIndexes().remove(each);
        }
    }

    private Collection<String> getIndexNames(DropIndexStatement dropIndexStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IndexSegment each : dropIndexStatement.getIndexes()) {
            result.add(each.getName());
        }
        return result;
    }

    private Optional<String> findLogicTableName(TableMetas tableMetas, String logicIndexName) {
        for (String each : tableMetas.getAllTableNames()) {
            if (!tableMetas.get(each).containsIndex(logicIndexName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Override
    public ShardingSphereMetaData getMetaData() {
        return this.metaData;
    }
}

